/***************************************************************************
                          note.h  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef Note_included
#define Note_included

#include "notedata.h"
#include "notebase.h"
#include <qpopupmenu.h>
#include <qwidget.h>
#include <qmultilinedit.h>
#include "kaspaurl.h"
#include "linklistbox.h"
#include <qaction.h>

/** GUI-class for Notes
 */
class Note : public NoteData
{
    Q_OBJECT
private:
		Note(const Note&);
		Note& operator=(const Note&);

protected:
    NoteBase *note;
		KaspaURL _url;
		LinkListBox		 *linklist;

		void save(bool block=false);

public:

    /** Load notice from WHERE clause. Must not return more than one row. Calls init().
     */
    Note(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
	Clears any messages in the statusline.
     */
    virtual ~Note();

    virtual const char *url() { return _url; }

    virtual void setWorkingGUI();
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isWorking() { return note->isWorking(); }
    virtual bool isReadOnly() { return note->isReadOnly(); }
    virtual bool closeRequest();
    virtual void setFields();

public slots:

    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
    virtual void flush();

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();

    void remLink();
    void showLink(Oid i, const char *s, bool w);
    void print();
    void insNote();
    void insAuthor();
/*  void insPubl();
    void insPart(); */
		KToolBar *getToolBar();

};

#endif // Note_included
























