/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 * PostScript(R) is a registered trademark of Adobe Systems Incorporated.
 */

#ifndef PRINTDLG_H
#define PRINTDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qpainter.h>

#include <kdialog.h>
#include <kconfig.h>

#include "mlofile.h"


class PrintDlg: public KDialog
{
	Q_OBJECT
public:
	PrintDlg(QWidget *parent = 0, const char *name = 0);
	~PrintDlg();

	void printFax(const QString &name);

protected:
	void  readOptions();
	void  saveOptions();

protected slots:
	void slotBrowse();
	
	void slotHelp();
	void slotOk();

	void destinationSelected(int id_);
	void fileNameChanged(const QString &text);
	void level2Selected(bool on);
	void rangeSelected(int id_);
	void fromPageChanged(int fp);
	void toPageChanged(int tp);

private:
	KConfig *config;

	int pid;

	bool to_printer;
	bool print_range;

	QButtonGroup *destination;
	QListView *printers;
	QLineEdit *file;
	QPushButton *browse;

	QCheckBox *level2;
	QCheckBox *interpolate;
	
	QComboBox *orientation;
	QComboBox *paper_format;

	QButtonGroup *range;
	QRadioButton *prt_all, *prt_range;
	QLabel *from_page_label;
	QSpinBox *from_page;
	QLabel *to_page_label;
	QSpinBox *to_page;

	QSpinBox *copies;
	QCheckBox *ribbons;

	QPushButton *ok;

	QString m_name;
	int max_page;
};


#endif // PRINTDLG_H
