/*
 * KMLOCfg
 *
 * A utility to configure modems of the ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifndef KMLOCFG_H 
#define KMLOCFG_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qframe.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include <kprogress.h>
#include <kmainwindow.h>
#include <kconfig.h>
#include <kaction.h>

#include "configure.h"
#include "mloloader.h"
#include "setupdlg.h"


class StatusProgress: public QFrame
{
	Q_OBJECT
public:
	StatusProgress(QWidget *parent = 0, const char *name = 0);
	~StatusProgress();

	void setEnabled(bool enable);
	
public slots:
	void setTotalSteps(int totalSteps);
	void setProgress(int valus);

protected slots:
	void abortSlot();

signals:
	void aborted();

private:
	QPushButton *abort;
	KProgress *progress;
};


inline void	StatusProgress::setTotalSteps(int totalSteps)
{	progress->setRange(0, totalSteps); }


inline void	StatusProgress::setProgress(int value)
{	progress->setValue(value); }





class KMLOCfg: public KMainWindow
{
	Q_OBJECT
public:
	KMLOCfg(QWidget *parent = 0, const char *name = 0);
	virtual ~KMLOCfg();

protected:
	void readOptions();

	void initActions();
	void initMenuBar();
	void initToolBar();
	void initStatusBar();

public slots:
	void slotFileRead();
	void slotFileWrite();
	void slotFileQuit();

	void slotExtrasDevConfig();
	
	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	void slotSettingsSaveOptions();
	void slotSettingsConfigure();

	void slotStatusMsg(const QString &text);
	void slotStatusHelpMsg(const QString &text);

private slots:
	void slotFetchDone(int action, bool success);

private:
	KConfig *config;

	KAction *fileRead, *fileWrite, *fileQuit;
	KAction *extrasDevConfig;
	KToggleAction *settingsShowToolbar, *settingsShowStatusbar;
	KAction *settingsSaveOptions, *settingsConfigure;

	SetupWidget *view;
	MLOLoader *loader;

	StatusProgress *progress;

	bool has_config;
	bool has_dev_config;
};

#endif // KMLOCFG_H 
