/**
 * kdesubsystem.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KDESUBSYSTEM_H
#define KDESUBSYSTEM_H

#include "interfaces/subsystem.h"

#include <kio/global.h>

#include <kconfig.h>

#include <qptrdict.h>
#include <qvaluelist.h>

namespace KIO {
    class Job;
    class SimpleJob;
}
class QDomElement;
class KFileItem;

namespace KConfigEditor
{
    class ConfigurationView;

    class KDESubsystem : public Subsystem
    {
        Q_OBJECT
    public:
        KDESubsystem( QObject *parent );

        virtual QString protocol() const
        {
            return "kde";
        }

    public slots:
        virtual void setValue( const KURL &item, const QVariant &value );
        virtual void saveToken( EntryToken *token );
        virtual void parse( ConfigurationView *view );
    protected:
        virtual void saveConfig( GroupToken *token );

        void createListJob( const QString &dir, bool kcfg=false );

    protected slots:
        void parseNextFile();
        void slotEntries( KIO::Job *job, const KIO::UDSEntryList &lst );
        void slotListResult( KIO::Job* job );
        void slotListCanceled( KIO::Job *job );
        void startAttaching();

    protected:
        void parseKCFGFile( const KFileItem &fitem );
        GroupToken *parseKCFGXML( const QDomElement &el, const QString &fname  );
        void addKConfigValues( GroupToken *app );
        void parseKCFGXMLEntry( const QDomElement &el, GroupToken *group );
        void parseKConfigFile( const KFileItem &fitem );
        bool tokenExists( const QString &name );
        bool skipFile( const QString &fileName );
        void writeGroupEntry( KConfig &config, GroupToken *token );
        void writeEntry( KConfig &config, EntryToken *token );

    private:
        int m_allItems;
        int m_parsedItems;
        bool m_attaching;
        ConfigurationView  *m_view;
        QPtrDict<KIO::Job> m_pendingKCFG;
        QValueList< QPair<KIO::UDSEntry, KURL> >  m_kcfgURLS;
        QValueList< QPair<KIO::UDSEntry, KURL> >  m_kconfigURLS;
        QDictIterator<GroupToken> m_attachIterator;
        int m_pendingJobs;
        bool m_finishedParsing;
    };
}

#endif
