#include <qapplication.h>

#include "propertyeditor.h"
#include "propertylist.h"
#include "multiproperty.h"

using namespace PropertyLib;

int main( int argc, char **argv )
{
    QApplication app( argc, argv );

    PropertyEditor *editor = new PropertyEditor( 0 );

    PropertyList *currentList = new PropertyList();

    currentList->addProperty(
        new Property(Property::String, "Sample string",
                     "Sample description", "value" ) );
    currentList->addProperty(
        new Property(Property::Color, "Color",
                     "Sample color description", Qt::red ) );
    currentList->addProperty(
        new Property( Property::Pixmap, "Pixmap",
                      "sample pixmap description" ) );
    currentList->addProperty(
        new Property( Property::Rect, "Rectangle",
                      "sample rectangle", QRect( 10, 11, 30, 40 ) ) );
    currentList->addProperty(
        new Property( Property::Point, "Point",
                      "sample point", QPoint( 20, 30 ) ) );
    currentList->addProperty(
        new Property( Property::Boolean, "Boolean",
                      "sample bool", false ) );
    currentList->addProperty(
        new Property( Property::Integer, "Integer",
                      "sample integer", 7 ) );

    editor->populateProperties( currentList );

    app.setMainWidget( editor );
    editor->show();

    return app.exec();
}
