/**
 * confwindow.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "confwindow.h"
#include "viewmanager.h"
#include "configurationview.h"
#include "configsearchline.h"
#include "descriptionwidget.h"
#include "kernel.h"
#include "configmanager.h"

#include "progressdialog.h"
#include "statusbarprogresswidget.h"

#include "propertyeditor/propertyeditor.h"

#include <klistview.h>
#include <ktabwidget.h>
#include <kpushbutton.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kstatusbar.h>
#include <kmessagebox.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstdaccel.h>
#include <klocale.h>
#include <kdebug.h>

#include <qsplitter.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtimer.h>

using namespace PropertyLib;

namespace KConfigEditor {

ConfWindow::ConfWindow( const char *title )
    : KMainWindow( 0L, title )
{
    initActions();
    initGUI();
    initStatusbar();
    initConnections();
    slotStatusMsg( "" );
    createGUI( "kconfigeditorui.rc" );
    QTimer::singleShot( 0, this, SLOT(delayedInit()) );
}

void
ConfWindow::delayedInit()
{
    m_mainWidget->setDisabled( true );
    kernel->emitStatusMsg( i18n( "Parsing configuration files..." ) );
    kernel->manager()->parse( m_view );
}

void
ConfWindow::initActions()
{
    KStdAction::save( this, SLOT(slotSave()), actionCollection() );
    KStdAction::quit( this, SLOT(close()), actionCollection() );
    new KAction( i18n("Show Changes"), Key_M, this,
                 SLOT(slotShowChanges()), actionCollection(),
                 "view_changes" );
    /*KStdAction::undo( this, SLOT(slotUndo()), actionCollection(), "kconfedit_undo" )
      ->setEnabled( false );*/
}

void
ConfWindow::initStatusbar()
{
    /* Create a progress dialog and hide it. */
    m_progressDialog = new ProgressDialog( statusBar(), this );
    m_progressDialog->hide();

    m_littleProgress = new StatusbarProgressWidget( m_progressDialog, statusBar() );

    statusBar()->addWidget( m_littleProgress, 0 , true );
    statusBar()->insertItem( i18n(" Initializing..."), 1, 1 );
    statusBar()->setItemAlignment( 1, AlignLeft | AlignVCenter );
    m_littleProgress->show();
}

void
ConfWindow::initGUI()
{
    QSplitter *s1 = new QSplitter( QSplitter::Horizontal, this, "main" );
    s1->setFrameShape( QFrame::Box );
    QVBox *box = new QVBox( s1 );
    ConfigSearchLine *line = new ConfigSearchLine( box );
    m_view = new ConfigurationView( box );
    line->setListView( m_view );

    QSplitter *s2 = new QSplitter( QSplitter::Vertical, s1, "sub" );
    m_editor = new PropertyEditor( s2 );
    m_descrWidget = new DescriptionWidget( s2 );

    setCentralWidget( s1 );
    m_mainWidget = s1;
    m_manager = new ViewManager( m_view, m_editor, m_descrWidget );
}

void
ConfWindow::initConnections()
{
    connect( kernel, SIGNAL(statusMsg(const QString&)),
             SLOT(slotStatusMsg(const QString&)) );
    connect( kernel->manager(), SIGNAL(parsingFinished()),
             SLOT(slotDoneParsing()) );
}

void
ConfWindow::slotDoneParsing()
{
    kernel->emitStatusMsg( i18n( "Application ready" ) );
    m_mainWidget->setEnabled( true );
}

void
ConfWindow::slotUndo()
{
    //later
}

void
ConfWindow::slotStatusMsg( const QString &msg )
{
    if ( !statusBar() || !m_littleProgress )
        return;

    QString text = " " + msg + " ";
    int statusWidth = statusBar()->width() - m_littleProgress->width()
                      - fontMetrics().maxWidth();

    while ( !text.isEmpty() && fontMetrics().width( text ) >= statusWidth )
        text.truncate( text.length() - 1);

    statusBar()->changeItem( text, 1 );
}

void
ConfWindow::slotAddEntry()
{
}

void
ConfWindow::slotRemoveEntry()
{
}

void
ConfWindow::slotUpdateActions( bool )
{
}

void
ConfWindow::slotSave()
{
    kernel->manager()->save();
}

void
ConfWindow::slotShowChanges()
{
    kernel->manager()->showChangesView();
}

}

#include "confwindow.moc"
