/**
 * memento.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_MEMENTO_H
#define KONFIG_MEMENTO_H

#include <qvariant.h>
#include <qstring.h>

namespace KCfgCreator
{
class Token;
class EntryToken;
class GroupToken;

class Memento
{
public:
    Memento( Token *token );
    virtual ~Memento();

    virtual void restore();
protected:
    friend class UndoManager;
    Token *m_token;
private:
    QString m_tokenName;
};

class EntryMemento : public Memento
{
public:
    typedef void (EntryToken::*StringListSetter)( const QStringList& );
    typedef void (EntryToken::*StringSetter)( const QString& );

    EntryMemento( EntryToken *token, const QString& data,
                  StringSetter setter );
    EntryMemento( EntryToken *token, const QStringList& data,
                  StringListSetter setter );

    void restore();
private:
    QString     m_strData;
    QStringList m_strListData;

    StringSetter     m_setter1;
    StringListSetter m_setter2;
};

class GroupMemento : public Memento
{
public:
    enum Change {
        Removed,
        Added
    };
    GroupMemento( GroupToken *token, EntryToken *entry, Change change );
    void restore();
private:
    EntryToken *m_changedToken;
    Change      m_change;
};

}

#endif
