/**
 * kcfgcreator_part.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "kcfgcreator_part.h"

#include "mainwidget.h"

#include <kapplication.h>
#include <kparts/genericfactory.h>
#include <kaboutdata.h>
#include <kinstance.h>
#include <kconfig.h>
#include <kdebug.h>



typedef KParts::GenericFactory< KCfgCreatorPart > KCfgCreatorFactory;
K_EXPORT_COMPONENT_FACTORY( libkcfgcreatorpart, KCfgCreatorFactory )

KAboutData *KCfgCreatorPart::s_about = 0;

KCfgCreatorPart::KCfgCreatorPart( QWidget *parentWidget, const char */*widgetName*/,
                                  QObject *parent, const char *name, const QStringList& )
    : KParts::ReadWritePart( parent, name )
{
    setInstance( KCfgCreatorPart::instance() );
    m_widget = new MainWidget( parentWidget );

    setXMLFile( "kcfgcreatorui.rc" );
}

KCfgCreatorPart::~KCfgCreatorPart()
{

}

void KCfgCreatorPart::setReadWrite( bool )
{
}

KAboutData *KCfgCreatorPart::createAboutData()
{
    if ( !s_about ) {
        s_about = new KAboutData( "kcfgcreator_part", I18N_NOOP("KCfgCreator Part"), "0.3",
                                  I18N_NOOP("KCfgCreator"),
                                  KAboutData::License_GPL, "(C) 2004 Zack Rusin", 0,
                                  0, "zack@kde.org" );
        s_about->addAuthor( "Zack Rusin", "Author", "zack@kde.org" );
    }
    return s_about;
}

bool KCfgCreatorPart::openFile()
{
    m_widget->parseFile();
    return true;
}

bool KCfgCreatorPart::saveFile()
{
    m_widget->save();
    return true;
}

#include "kcfgcreator_part.moc"
