/**
 * hostdata.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_HOSTDATA_H
#define KONFIG_HOSTDATA_H

#include <kurl.h>

#include <qobject.h>
#include <qptrlist.h>

namespace KCfgCreator
{
    class HostData;

    class FileData
    {
    public:
        FileData( HostData* parent, const KURL& url, bool isKCfg );
        ~FileData();

        bool isFinished() const;
        bool isReadOnly() const;
        bool isKCfg() const;

        void setParent( HostData* );
        void setReadOnly( bool );
        void finished();
        void error();

        QString host() const;
        QString fileName() const;

        KURL url() const;

        QCString data;
    private:
        HostData* m_parent;
        KURL m_url;
        bool m_finished;
        bool m_readOnly;
        bool m_kcfg;
    };

    class HostData : public QObject
    {
        Q_OBJECT
    public:
        HostData( const KURL& url );
        ~HostData();

        void add( FileData* );
        void addList( const QPtrList<FileData>& l );
        void remove( FileData* );
        void fileFinished();

        QPtrList<FileData>& kcfgFiles();
        QPtrList<FileData>& kconfigFiles();

        FileData *popKCfg();
        FileData *popKConfig();

        KURL url() const;

        bool isDone() const;
        void setDone( bool );

    signals:
        void done( HostData* );

    protected:
        friend class Downloader;
        void addNumberOfWaitingUrls( int );
        void decrementNumberOfWaitingUrls();
        bool waitingForUrls() const;

        void addKCfgPath( const KURL& url );
        void addKConfigPath( const KURL& url );
        bool isKCfgPath( const KURL& url ) const;
        bool isKConfigPath( const KURL& url ) const;
        void checkFinished();

    private:
        KURL m_url;
        int m_unfinishedCount;
        QPtrList<FileData> m_kcfgFiles;
        QPtrList<FileData> m_kconfigFiles;
        bool m_kcfg;

        int m_numberOfWaiting;
        KURL::List m_kcfgPaths;
        KURL::List m_kconfigPaths;
        bool m_done;
    };
}

#endif
