/*
   Copyright (C) 2018-2020 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "dkimdownloadkeyjobtest.h"
#include "dkim-verify/dkimdownloadkeyjob.h"
#include <QTest>
QTEST_MAIN(DKIMDownloadKeyJobTest)

DKIMDownloadKeyJobTest::DKIMDownloadKeyJobTest(QObject *parent)
    : QObject(parent)
{
}

void DKIMDownloadKeyJobTest::shouldHaveDefaultValues()
{
    MessageViewer::DKIMDownloadKeyJob job;
    QVERIFY(job.domainName().isEmpty());
    QVERIFY(job.selectorName().isEmpty());
    QVERIFY(!job.canStart());
    QVERIFY(!job.dnsLookup());
}

void DKIMDownloadKeyJobTest::shouldTestCanStart()
{
    MessageViewer::DKIMDownloadKeyJob job;
    QVERIFY(!job.canStart());
    job.setDomainName(QStringLiteral("bla"));
    QVERIFY(!job.canStart());
    job.setSelectorName(QStringLiteral("bli"));
    QVERIFY(job.canStart());
    job.setDomainName(QString());
    QVERIFY(!job.canStart());
}

void DKIMDownloadKeyJobTest::shouldVerifyResolveDns()
{
    MessageViewer::DKIMDownloadKeyJob job;
    job.setDomainName(QStringLiteral("bla"));
    job.setSelectorName(QStringLiteral("bli"));
    QCOMPARE(job.resolvDnsValue(), QStringLiteral("bli._domainkey.bla"));
}
