#include "parserdialog.h"
#include "cupsparserview.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qdatetimeedit.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <kurlrequester.h>
#include <klocale.h>
#include <knuminput.h>
#include <kseparator.h>

ParserDialog::ParserDialog( QWidget *parent, const char *name )
	: KDialogBase( parent, name, true, QString::null, Ok|Cancel )
{
	QWidget *dummy = new QWidget( this );

	QGroupBox *viewbox = new QGroupBox( 2, Qt::Vertical, i18n( "View options" ), dummy );
	QGroupBox *parserbox = new QGroupBox( 0, Qt::Vertical, i18n( "Parser options" ), dummy );
	QVBoxLayout *l0 = new QVBoxLayout( dummy, 0, 10 );
	l0->addWidget( viewbox );
	l0->addWidget( parserbox );

	m_viewlimit = new KIntNumInput( -1, viewbox );
	m_viewlimit->setRange( -1, 100000, 1, false );
	m_viewlimit->setSpecialValueText( i18n( "Unlimited" ) );
	m_viewlimit->setLabel( i18n( "&Maximum number of events shown:" ), Qt::AlignVCenter|Qt::AlignLeft );
	m_restorecheck = new QCheckBox( i18n( "&Restore this view at startup" ), viewbox );
	m_filename = new KURLRequester( parserbox );
	QLabel *filelabel = new QLabel( i18n( "&Log file:" ), parserbox );
	filelabel->setBuddy( m_filename );
	m_interval = new KIntNumInput( 2000, parserbox );
	m_interval->setRange( 0, 100000, 1, false );
	m_interval->setLabel( i18n( "&Delay between parsing checks (ms):" ), Qt::AlignVCenter|Qt::AlignLeft );
	KSeparator *sep1 = new KSeparator( parserbox );
	sep1->setMinimumHeight( 10 );
	m_startcheck = new QCheckBox( i18n( "&Parse only last events, starting from the end at:" ), parserbox );
	m_start = new KIntNumInput( 1000, parserbox );
	m_start->setRange( 0, 100000, 1, false );
	connect( m_startcheck, SIGNAL( toggled( bool ) ), m_start, SLOT( setEnabled( bool ) ) );
	m_start->setEnabled( false );
	KSeparator *sep2 = new KSeparator( parserbox );
	sep2->setMinimumHeight( 10 );
	m_fieldcheck = new QCheckBox( i18n( "&Keep only events matching the following field pattern" ), parserbox );
	m_field = new QComboBox( parserbox );
	m_match = new QLineEdit( parserbox );
	connect( m_fieldcheck, SIGNAL( toggled( bool ) ), m_field, SLOT( setEnabled( bool ) ) );
	connect( m_fieldcheck, SIGNAL( toggled( bool ) ), m_match, SLOT( setEnabled( bool ) ) );
	m_field->setEnabled( false );
	m_match->setEnabled( false );
	m_datecheck = new QCheckBox( i18n( "K&eep only events with a matching date" ), parserbox );
	m_from = new QDateEdit( parserbox );
	m_to = new QDateEdit( parserbox );
	connect( m_datecheck, SIGNAL( toggled( bool ) ), m_from, SLOT( setEnabled( bool ) ) );
	connect( m_datecheck, SIGNAL( toggled( bool ) ), m_to, SLOT( setEnabled( bool ) ) );
	m_from->setEnabled( false );
	m_to->setEnabled( false );
	QLabel *fromlabel = new QLabel( i18n( "&From:" ), parserbox );
	QLabel *tolabel = new QLabel( i18n( "&To:" ), parserbox );
	tolabel->setBuddy( m_to );
	fromlabel->setBuddy( m_from );

	QVBoxLayout *l1 = new QVBoxLayout( parserbox->layout(), 5 );
	QHBoxLayout *l2 = new QHBoxLayout( 0, 0, 10 );
	l1->addLayout( l2 );
	l2->addWidget( filelabel );
	l2->addWidget( m_filename );
	l1->addWidget( m_interval );
	l1->addWidget( sep1 );
	QHBoxLayout *l3 = new QHBoxLayout( 0, 0, 5 );
	l1->addLayout( l3 );
	l3->addWidget( m_startcheck );
	l3->addWidget( m_start );
	l1->addWidget( sep2 );
	l1->addWidget( m_fieldcheck );
	QHBoxLayout *l4 = new QHBoxLayout( 0, 0, 5 );
	l1->addLayout( l4 );
	l4->addWidget( m_field );
	l4->addWidget( m_match );
	l1->addSpacing( 10 );
	l1->addWidget( m_datecheck );
	QHBoxLayout *l5 = new QHBoxLayout( 0, 0, 3 );
	l1->addLayout( l5 );
	l5->addWidget( fromlabel );
	l5->addWidget( m_from, 1 );
	l5->addSpacing( 10 );
	l5->addWidget( tolabel );
	l5->addWidget( m_to, 1 );

	setMainWidget( dummy );
	resize( 420, 300 );
}

ParserDialog::~ParserDialog()
{
}

void ParserDialog::setParser( CupsParserView *view )
{
	m_viewlimit->setValue( view->limit() );
	m_restorecheck->setChecked( view->restored() );
	CupsParser *parser = view->parser();
	m_filename->setURL( parser->fileName() );
	int val = parser->start();
	if ( val != -1 )
	{
		m_startcheck->setChecked( true );
		m_start->setValue( val );
	}
	m_interval->setValue( parser->parseInterval() );
	QStringList fields = parser->fields();
	for ( QStringList::ConstIterator it=fields.begin(); it!=fields.end(); ++it )
		m_field->insertItem( *it );
	val = parser->filterField();
	if ( val != -1 )
	{
		m_fieldcheck->setChecked( true );
		m_field->setCurrentItem( val );
		m_match->setText( parser->filterMatch() );
	}
	m_from->setDate( parser->filterFrom().date() );
	m_to->setDate( parser->filterTo().date() );
	m_datecheck->setChecked( parser->filterFrom().isValid() || parser->filterTo().isValid() );

	QString pName = view->parser()->parserName();
	pName = pName.left( pName.length()-6 );
	setCaption( i18n( "Configure parser: %1" ).arg( pName ) );
	m_restorecheck->setText( m_restorecheck->text() + " (" + pName + ")" );
}

void ParserDialog::updateParser( CupsParserView *view )
{
	view->setLimit( m_viewlimit->value() );
	view->setRestored( m_restorecheck->isChecked() );
	CupsParser *parser = view->parser();
	if ( m_filename->url() != parser->fileName() )
		parser->setFileName( m_filename->url() );
	parser->setStart( ( m_startcheck->isChecked() ? m_start->value() : -1 ) );
	parser->setParseInterval( m_interval->value() );
	if ( m_fieldcheck->isChecked() && !m_match->text().isEmpty() )
		parser->setFilter( m_field->currentItem(), m_match->text() );
	else
		parser->setFilter( -1, QString::null );
	if ( m_datecheck->isChecked() )
		parser->setFilter( QDateTime( m_from->date() ), QDateTime( m_to->date() ) );
	else
		parser->setFilter( QDateTime(), QDateTime() );
}

#include "parserdialog.moc"
