#include "cupsparserwindow.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmainwindow.h>

static KCmdLineOptions options[] = 
{
	{ "access", I18N_NOOP( "Open the access log window" ), 0 },
	{ "error", I18N_NOOP( "Open the error log window" ), 0 },
	{ "page", I18N_NOOP( "Open the page log window" ), 0 },
	{ "all", I18N_NOOP( "Open all log windows" ), 0 },
	{ 0, 0, 0 }
};

int main( int argc, char **argv )
{
	KAboutData aData( "cupslogtool", "CUPS Log Viewer", "0.1",
			I18N_NOOP( "A tool to view, analyze and manipulate CUPS log files." ),
			KAboutData::License_GPL, 0, 0, "http://printing.kde.org");
	aData.addAuthor( "Michael Goffioul", I18N_NOOP( "Main developer" ), "goffioul@imec.be" );
	KCmdLineArgs::init( argc, argv, &aData );
	KCmdLineArgs::addCmdLineOptions( options );

	KApplication app;
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	CupsParserWindow *w = 0;
	if ( args->isSet( "access" ) || args->isSet( "all" ) )
	{
		w = new CupsParserWindow( CupsParserWindow::Access );
		w->show();
	}
	if ( args->isSet( "error" ) || args->isSet( "all" ) )
	{
		w = new CupsParserWindow( CupsParserWindow::Error );
		w->show();
	}
	if ( args->isSet( "page" ) || args->isSet( "all" ) )
	{
		w = new CupsParserWindow( CupsParserWindow::Page );
		w->show();
	}

	if ( w == 0 )
	{
		// no window opened so far
		CupsParserWindow::restoreWindows();
	}

	int result = app.exec();
	return result;
}
