#include <qpainter.h>

#include "kdisc.h"

KDisc::KDisc (QWidget *parent, const char *name=0) :
  QWidget (parent, name)
{
  
  discposition = QPoint (0, 0);
  setMouseTracking (true);
}

void
KDisc::paintEvent (QPaintEvent *)
{
  QPainter painter (this);

  //Chapter 4, Exercise 4

  painter.setPen ( QPen (QColor (200, 100, 0), 1) );
  painter.setBrush ( QBrush (Qt::green, Qt::SolidPattern) );

  painter.drawPie (discposition.x(), discposition.y(),
		       45, 45, 0, 4760);
}

void
KDisc::mouseMoveEvent (QMouseEvent *qmouseevent)
{

  if (qmouseevent->state()==Qt::LeftButton)
    {
      //Chapter 4, Exercise 4
      QPoint qpoint = qmouseevent->pos();
      qpoint.setX(qpoint.x() - 45/2);
      qpoint.setY(qpoint.y() - 45/2);
      discposition = qpoint;
      update();
    }
  
}

void
KDisc::keyPressEvent (QKeyEvent *qkeyevent)
{

  switch (qkeyevent->key())
    {
    case Qt::Key_Left:
      discposition = QPoint ( discposition.x()-10,
			      discposition.y() );
      update();
      break;
    case Qt::Key_Right:
      discposition = QPoint ( discposition.x()+10,
			      discposition.y() );
      update();
      break;
    case Qt::Key_Up:
      discposition = QPoint ( discposition.x(),
			      discposition.y()-10 );
      update();
      break;
    case Qt::Key_Down:
      discposition = QPoint ( discposition.x(),
			      discposition.y()+10 );
      update();
      break;
    default:
      qkeyevent->ignore();
    }

}
