#include "

void TopLevel::saveProperties(KConfig* config)
{
    // Test if document needs to be saved
    // If empty AND isn't modified, no need to save.
    if(location.isEmpty() && !eframe->isModified())
        return;

    // Store the config filename
    config->writeEntry("filename",name());
    // Store the state of modification, if it's modified,
    // we'll also store a temporary file elsewhere
    config->writeEntry("modified",eframe->isModified());

    if(eframe->isModified())
    {
         QString tmplocation = kapp->tempSaveName(name());
         saveFile(tmplocation);
    }
}

void TopLevel::readProperties(KConfig* config)
{
    QString filename = config->readEntry("filename","");
    int modified = config->readNumEntry("modified",0);

    if(!filename.isEmpty() && modified)
    {
         bool ok;
         QString fn = kapp->checkRecoverFile(filename,ok);

         if(ok)
         { // Yes, there's a temporary file, and it's in 'fn'
              openFile(fn,KEdit::OPEN_READWRITE);
              location = filename;
              eframe->setModified();
              setFileCaption();
         }
    }
    else if(!filename.isEmpty())
    { // No temp file, so we just open up the previously
      // opened file.
         openFile(filename,KEdit::OPEN_READWRITE);
         location = filename;
         eframe->setModified(false);
         setFileCaption();
    }
}
