#include <stdio.h>

#include <qdragobject.h>

#include "kdropdemo.h"

KDropDemo::KDropDemo (QWidget *parent, const char *name) :
  QLabel (parent, name)
{
  setAcceptDrops(true);

  setAlignment (AlignCenter);
  setText ("Drop\nan\n     image     \non\n me!");
}

void
KDropDemo::dragEnterEvent (QDragEnterEvent *qdragenterevent)
{
  qdragenterevent->accept (QImageDrag::canDecode (qdragenterevent));
}

void
KDropDemo::dropEvent (QDropEvent *qdropevent)
{
  QPixmap qpixmap;
  
  if (QImageDrag::decode (qdropevent, qpixmap))
    {
      setPixmap (qpixmap);
    }
}
