// exercise3.cc
 
#include "artsflow.h"
#include "connect.h"

using namespace Arts;
 
int main()
{
    Dispatcher dispatcher;
 
    Synth_FREQUENCY freq1,freq2,freqspin;   // object creation
    Synth_WAVE_SIN  sin1,sin2,sinspin;
    Synth_MUL       mulspin1,mulspin2;
    Synth_ADD       addspin1,addspin2;
    Synth_MUL       mul1spin1,mul1spin2,mul2spin1,mul2spin2;
    Synth_ADD       addleft,addright;
    Synth_PLAY      play;
 
    setValue(freq1, 440.0);       // set frequencies
    setValue(freq2, 880.0);
    setValue(freqspin, 0.4);
 
    connect(freq1, sin1);         // object connection
    connect(freq2, sin2);
    connect(freqspin, sinspin);
 
    // first side: (freqspin * 0.5) + 0.5  (is between 0..1)
    connect(sinspin, mulspin1, "invalue1");
    setValue(mulspin1, "invalue2", 0.5);
    connect(mulspin1, addspin1, "invalue1");
    setValue(addspin1, "invalue2",0.5);
 
    // first side: (freqspin * (-0.5)) + 0.5  (is between 1..0)
    connect(sinspin, mulspin2, "invalue1");
    setValue(mulspin2, "invalue2", -0.5);
    connect(mulspin2, addspin2, "invalue1");
    setValue(addspin2, "invalue2",0.5);
 
    // multiply sin1 with the (0..1) and (1..0) ranges
    connect(sin1,mul1spin1,"invalue1");
    connect(addspin1,mul1spin1,"invalue2");
    connect(sin1,mul1spin2,"invalue1");
    connect(addspin2,mul1spin2,"invalue2");
 
    // multiply sin2 with the (0..1) and (1..0) ranges
    connect(sin2,mul2spin1,"invalue1");
    connect(addspin1,mul2spin1,"invalue2");
    connect(sin2,mul2spin2,"invalue1");
    connect(addspin2,mul2spin2,"invalue2");
 
    // left channel output
    connect(mul1spin1,addleft,"invalue1");
    connect(mul2spin2,addleft,"invalue2");
    connect(addleft, play, "invalue_left");
 
    // right channel output
    connect(mul2spin1,addright,"invalue1");
    connect(mul1spin2,addright,"invalue2");
    connect(addright, play, "invalue_right");
 
    // start and go ;-)
    freq1.start(); freq2.start(); freqspin.start();
    sin1.start(); sin2.start(); sinspin.start();
    mulspin1.start(); mulspin2.start();
    addspin1.start(); addspin2.start();
    mul1spin1.start(); mul1spin2.start();
    mul2spin1.start(); mul2spin2.start();
    addleft.start(); addright.start();
    play.start();
    dispatcher.run();
}
