#include "TabDialog.h"


TabDialog::TabDialog(Widget *parent=0, const char *name=0, int modal=0)
{
  if(parent)
    setWidget(new QTabDialog(parent->widget, name, modal));
  else
    setWidget(new QTabDialog(NULL, name, modal));
}

TabDialog::~TabDialog()
{
}

void TabDialog::setWidget(QTabDialog *td)
{
  tabdialog = td;

  QObject::connect(tabdialog,SIGNAL(aboutToShow()),
		   this,SLOT(aboutToShow()));
  QObject::connect(tabdialog,SIGNAL(applyButtonPressed()),
		   this,SLOT(applyButtonPressed()));
  QObject::connect(tabdialog,SIGNAL(cancelButtonPressed()),
		   this,SLOT(cancelButtonPressed()));
  QObject::connect(tabdialog,SIGNAL(defaultButtonPressed()),
		   this,SLOT(defaultButtonPressed()));

  Dialog::setWidget((QDialog*)tabdialog);
}

void TabDialog::show()
{
  tabdialog->show();
}

void TabDialog::setFont(const QFont& font)
{
  tabdialog->setFont(font);
}

void TabDialog::addTab(Widget *w, const char *name)
{
  if(w)
    {
      tabdialog->addTab(w->widget,name);
    }
  else
    tabdialog->addTab(NULL,name);
}

bool TabDialog::isTabEnabled(const char* name)
{
  return tabdialog->isTabEnabled(name);
}

void TabDialog::setDefaultButton(const char* text)
{
  tabdialog->setDefaultButton(text);
}

bool TabDialog::hasDefaultButton() const
{
  return tabdialog->hasDefaultButton();
}

void TabDialog::setCancelButton(const char* text)
{
  tabdialog->setCancelButton(text);
}

bool TabDialog::hasCancelButton() const
{
  return tabdialog->hasCancelButton();
}

void TabDialog::setApplyButton(const char *text)
{
  tabdialog->setApplyButton(text);
}

bool TabDialog::hasApplyButton() const
{
  return tabdialog->hasApplyButton();
}

void TabDialog::setOKButton(const char* text)
{
  tabdialog->setOKButton(text);
}


//SIGNALS
void TabDialog::aboutToShow()
{
  emit("aboutToShow",NULL);
}

void TabDialog::applyButtonPressed()
{
  emit("applyButtonPressed",NULL);
}

void TabDialog::cancelButtonPressed()
{
  emit("cancelButtonPressed",NULL);
}

void TabDialog::defaultButtonPressed()
{
  emit("defaultButtonPressed",NULL);
}




