#ifndef PUSHBUTTON
#define PUSHBUTTON

#include "Widget.h"
#include "Button.h"
#include <qpushbt.h>

class PushButton : public Button
{
  Q_OBJECT;
public:
  PushButton(Widget *parent=0, const char *name=0);
  PushButton(const char *text = 0, Widget *parent = 0, const char *name=0);

  void setToggleButton(int toggle);
  bool autoDefault() const;
  void setAutoDefault(int autoDefault);
  bool isDefault() const;
  void setDefault(int def);
  QSize sizeHint() const;
  void move(int x, int y);
  void move(const QPoint & p);
  void resize(int w, int h);
  void resize(const QSize& size);
  void setGeometry(int x, int y, int w, int h);
  void setGeometry(const QRect& rect);

  /// SLOTS
public slots:
  void setOn(int on);
  void toggle();

public:
  QPushButton *pushbutton;
};
  
#endif
