/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QWMatrix.h"

qt_QWMatrix *qt_new_QWMatrix(){
	return (qt_QWMatrix *)new QWMatrix();
}
qt_QWMatrix *qt_new_QWMatrix1(float m11,float m12,float m21,float m22,float dx,float dy)

{
	return (qt_QWMatrix *) new QWMatrix( (float)m11,(float)m12,(float)m21,(float)m22,(float)dx,(float)dy );
}

void qt_del_QWMatrix (qt_QWMatrix *p)
{
delete (QWMatrix*) p;
}

void qt_QWMatrix_setMatrix( qt_QWMatrix *instPointer,float m11,float m12,float m21,float m22,float dx,float dy){
	((QWMatrix *)instPointer)->setMatrix((float )m11,(float )m12,(float )m21,(float )m22,(float )dx,(float )dy);
}
float qt_QWMatrix_m11( qt_QWMatrix *instPointer){
	return (float)((QWMatrix *)instPointer)->m11();
}
float qt_QWMatrix_m12( qt_QWMatrix *instPointer){
	return (float)((QWMatrix *)instPointer)->m12();
}
float qt_QWMatrix_m21( qt_QWMatrix *instPointer){
	return (float)((QWMatrix *)instPointer)->m21();
}
float qt_QWMatrix_m22( qt_QWMatrix *instPointer){
	return (float)((QWMatrix *)instPointer)->m22();
}
float qt_QWMatrix_dx( qt_QWMatrix *instPointer){
	return (float)((QWMatrix *)instPointer)->dx();
}
float qt_QWMatrix_dy( qt_QWMatrix *instPointer){
	return (float)((QWMatrix *)instPointer)->dy();
}
void qt_QWMatrix_map( qt_QWMatrix *instPointer,int x,int y,int tx,int ty){
	((QWMatrix *)instPointer)->map((int )x,(int )y,(int* )tx,(int* )ty);
}
void qt_QWMatrix_map1( qt_QWMatrix *instPointer,float x,float y,float* tx,float* ty){
	((QWMatrix *)instPointer)->map((float )x,(float )y,(float* )tx,(float* )ty);
}
qt_QPoint * qt_QWMatrix_map2( qt_QWMatrix *instPointer,qt_QPoint * arg1){
    QPoint p=((QWMatrix *)instPointer)->map((QPoint& )*arg1);
    return (qt_QPoint *)new QPoint(p.x(),p.y());
}
qt_QRect * qt_QWMatrix_map3( qt_QWMatrix *instPointer,qt_QRect * arg1){
    
    QRect r=((QWMatrix *)instPointer)->map((QRect& )*arg1);
    return (qt_QRect *)new QRect(r.left(),r.top(),r.width(),r.height());
}


/**************************************/
/*This function didn't wrap*/
/*XXX qt_QWMatrix_map4( qt_QWMatrix *instPointer,XXX arg1){*/
/*	return (XXX)((QWMatrix *)instPointer)->map((QPointArray& )arg1);*/
/*}*/
/**/

void qt_QWMatrix_reset( qt_QWMatrix *instPointer){
	((QWMatrix *)instPointer)->reset();
}
qt_QWMatrix * qt_QWMatrix_translate( qt_QWMatrix *instPointer,float dx,float dy){
    QWMatrix m=((QWMatrix *)instPointer)->translate((float )dx,(float )dy);
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
qt_QWMatrix * qt_QWMatrix_scale( qt_QWMatrix *instPointer,float sx,float sy){
    QWMatrix m=((QWMatrix *)instPointer)->scale((float )sx,(float )sy);
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
qt_QWMatrix * qt_QWMatrix_shear( qt_QWMatrix *instPointer,float sh,float sv){
    QWMatrix m=((QWMatrix *)instPointer)->shear((float )sh,(float )sv);
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
qt_QWMatrix * qt_QWMatrix_rotate( qt_QWMatrix *instPointer,float a){
    QWMatrix m=((QWMatrix *)instPointer)->rotate((float )a);
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
qt_QWMatrix * qt_QWMatrix_invert( qt_QWMatrix *instPointer,int* arg1){
    QWMatrix m=((QWMatrix *)instPointer)->invert((bool* )arg1);
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
