/////////////////////////////////////////////////////////////////////////////
//
// STDOUT plugin
//
// Time-stamp: <97/05/06 02:18:02 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "stdoutplug.h"
#include "stdoutplug.moc"

#define NUM_OPTIONS          1
#define NUM_INPUT_MIMETYPES  1


// Constructor
StdoutPlugin::StdoutPlugin() :
  m_width(80)
{
  // Specify plugin type
  setType(KPlugin::Output);
  
  // Create array of member functions for handling different input types.
  // (currently we have only one input type - "text/plain")
  m_input = new MemberFunction[NUM_INPUT_MIMETYPES];
  MemberFunction *ptr = m_input;

  // Specify input MIME types
  registerInputMIMEType("text/plain");
  *ptr++ = &StdoutPlugin::textInput;

  // Specify output MIME types
  // -- output plugin don't have output MIME types

  // Create array of member functions for setting/getting options.
  // Every even element points to a 'set' method and every odd element -
  // to a 'get' method.
  m_option = new MemberFunction[NUM_OPTIONS*2];
  ptr = m_option;

  // Register options
  registerOption("tty_width");
  *ptr++ = &StdoutPlugin::setWidth;
  *ptr++ = &StdoutPlugin::getWidth;
}

StdoutPlugin::~StdoutPlugin()
{
  delete m_option;
  delete m_input;
}


//        ------------------------- INPUT --------------------------

// Call appropriate input handler
int StdoutPlugin::callInputMemberFunction(int index, void *arg)
{
  return m_input[index](arg);
}

// New data arrived
int StdoutPlugin::textInput(void *data)
{
  printf("%s", (char *)data);
  return 0;
}


//        ------------------------ OPTIONS --------------------------

// Call appropriate action
int StdoutPlugin::callOptionMemberFunction(int index, void *arg)
{
  return m_option[index](arg);
}

// Change max line width
int StdoutPlugin::setWidth(void *arg)
{
  m_width = *(int *)arg;
  return 0;
}

// Return max line width
int StdoutPlugin::getWidth(void *arg)
{
  if (!arg)
    return -1;

  int *ptr = (int *)arg;
  *ptr = m_width;
  return 0;
}
