%module Pixmap

%{
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>
#include "Object.h"
%}


%import Object.i
%import Paintdevice.i
%include Color.i
%include Bitmap.i
%include Image.i
%import WMatrix.i


class QPixmap : public QPaintDevice
{
public:
    QPixmap( const QSize &, int depth=-1 );
%name(QPixmapFile)    QPixmap( const char *fileName, const char *format=0, int mode = 0 );
%name(QPixmapFileConvert)    QPixmap( const char *fileName, const char *format, int conversion_flags );
%name(QPixmapCopy)    QPixmap( const QPixmap & );

    ~QPixmap();

    bool	isNull()	const;

    int		width()		const { return data->w; }
    int		height()	const { return data->h; }
    QSize	size()		const { return QSize(data->w,data->h); }
    QRect	rect()		const { return QRect(0,0,data->w,data->h); }
    int		depth()		const { return data->d; }
    static int	defaultDepth();

    void	fill(QColor &color);
%name(fillWidget)    void	fill( const QWidget *, const QPoint &ofs );
    void	resize( const QSize & );

    const QBitmap *mask() const;
    void	setMask( const QBitmap & );
    bool	selfMask() const;
    QBitmap	createHeuristicMask( bool clipTight = TRUE ) const;

    static  QPixmap  grabWindow( unsigned int, int x=0, int y=0, int w=-1, int h=-1 );

    QPixmap	    xForm( const QWMatrix & ) const;
    static QWMatrix trueMatrix( const QWMatrix &, int w, int h );

    QImage	convertToImage() const;
%name(convertFromImageAuto)    bool	convertFromImage( const QImage &, int mode=0 );
    bool	convertFromImage( const QImage &, int conversion_flags );

    static const char *imageFormat( const char *fileName );
    bool	load( const char *fileName, const char *format=0,
		      int mode=0 );
%name(loadConversion)    bool	load( const char *fileName, const char *format,
		      int conversion_flags );
    bool	loadFromData( const unsigned char *buf, unsigned int len,
			      const char *format=0,
			      int mode=0 );
%name(loadFromDataConversion)    bool	loadFromData( const unsigned char *buf, unsigned int len,
			      const char *format,
			      int conversion_flags );
    bool	save( const char *fileName, const char *format ) const;

    int		serialNumber()	const;

    bool	isOptimized()	const;
    void	optimize( bool );
    static bool isGloballyOptimized();
    static void optimizeGlobally( bool );

    virtual void detach();

%name(isBitmap)    bool	isQBitmap()	const;

};
