#ifndef _BASEOBJECT_H_
#define _BASEOBJECT_H_

#include <Python.h>
#include <qlist.h>

#ifdef emit
#undef emit
#endif

class Connection
{
  friend class BaseObject;

  char *signal;
  PyObject *slot;
};

class BaseObject
{
public:

  BaseObject();
  ~BaseObject() {};

  void _connect(const char *signal, PyObject *slot);
  void _disconnect(const char *signal, PyObject *slot);
  void _emit(const char *signal, PyObject *args);

private:

  QList< Connection > connections;
};

#endif
