/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "klwindow.h"

KLWindow::KLWindow() : KTMainWindow("KLWindow"), view(this,"KLWindow_view")
{
  setView(&view);
  leftborder = 0;
  rightborder = 0;
  topborder = 0;
  bottomborder = 0;
}

KLWindow::~KLWindow()
{
  hideDevice();
}

ulong KLWindow::getLeftBorder() const
{
  return leftborder;
}

ulong KLWindow::getRightBorder() const
{
  return rightborder;
}

ulong KLWindow::getTopBorder() const
{
  return topborder;
}

ulong KLWindow::getBottomBorder() const
{
  return bottomborder;
}

void KLWindow::setDeviceSize(unsigned long xSize, unsigned long ySize)
{
  ulong xOrigSize = xSize;
  ulong yOrigSize = ySize;
  ulong xCSize,yCSize; // rootChild sizes
  bool doUpdate = false;
  if( xSize < dsi.minXSize ) {
    xSize = dsi.minXSize;
    doUpdate = true;
  }
  if( ySize < dsi.minYSize ) {
    ySize = dsi.minYSize;
    doUpdate = true;
  }
  view.resize(QSize(ySize,xSize));
  if( doUpdate ) 
    KTMainWindow::updateRects();
  calcRWSize(xSize,ySize);
  getRCSize(xCSize,yCSize);

  // Must we do a resize ?
  if( showed && (xSize == (ulong)height()) && ((ulong)width() == ySize) && 
      (xCSize == xOrigSize) && (yCSize == yOrigSize) )
    return;
  resize(QSize(ySize,xSize));
  KLDevice::setDeviceSize(xOrigSize,yOrigSize);
}


bool KLWindow::refreshDisplay()
{
  if( !KLDevice::refreshDisplay())
    return false;
  // update();
  return true;
}

void KLWindow::show()
{
  if( showed ) 
    KTMainWindow::show();
  else
    showDevice();
}

void KLWindow::hide()
{
  KTMainWindow::hide();
}


bool KLWindow::createWindow()
{
  // Nothing to be done for us
  return true;
}


bool KLWindow::showWindow( KLDeviceShowinfo *deviceShowInfo )
{
  ulong xSize = deviceShowInfo->xSize;
  ulong ySize = deviceShowInfo->ySize;
  calcRWSize(xSize,ySize);
  bool ok = KLDevice::showWindow(deviceShowInfo);
  resize(QSize(ySize,xSize));
  KTMainWindow::show();
  return ok;
}


void KLWindow::setLimits( KLDeviceShowinfo *deviceShowInfo )
{
  // Calcluate our real Window sizes 
  ulong maxX = deviceShowInfo->maxXSize;
  ulong maxY = deviceShowInfo->maxYSize;
  ulong minX = deviceShowInfo->minXSize;
  ulong minY = deviceShowInfo->minYSize;

  calcRWSize(minX,minY);
  calcRWSize(maxX,maxY);

  minX = KLMin(minX,QCOORD_MAX);
  minY = KLMin(minY,QCOORD_MAX);
  maxX = KLMin(maxX,QCOORD_MAX);
  maxY = KLMin(maxY,QCOORD_MAX);

  // And set the maximum/minimum sizes
  setMinimumSize(QSize(minY,minX));
  setMaximumSize(QSize(maxY,maxX));
}


void KLWindow::hideWindow()
{
  KTMainWindow::hide();
  KLDevice::hideWindow();
}

void KLWindow::deleteWindow()
{
  KLDevice::deleteWindow();
  // notting to be done for us
}


QWidget *KLWindow::getDeviceHandle()
{
  return &view;
}


void KLWindow::updateRects()
{
  static int level = 0;
  if( level )
    return;
  level++;
  KTMainWindow::updateRects();
  if(showed && isVisible()) {
    ulong xSize = height();
    ulong ySize = width();
    leftborder = view_left;
    rightborder = ySize - view_right;
    topborder = view_top;
    bottomborder = xSize - view_bottom;
    calcDSize(xSize,ySize);
    setDeviceSize(xSize,ySize);
  }
  level--;
}

void KLWindow::resizeEvent(QResizeEvent*e)
{
  KTMainWindow::resizeEvent(e);
}

#include "klwindow.moc"

