/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "klhelper.h"
#include "kllabel.h"
#include "klbutton.h"
#include "kledit.h"
#include "klcheckbox.h"
#include "klgroupbox.h"
#include "klgroup.h"
#include "kltools.h"
#include "kllistbox.h"

KLLabel *klLabel(const char *text)
{ 
  return new KLLabel(text);
}

KLButton *klButton(const char *text)
{ 
  return new KLButton(text);
}

KLCheckBox *klCheckBox(const char *text)
{ 
  return new KLCheckBox(text);
}

KLLineEdit *klLineEdit(const char *text)
{ 
  return new KLLineEdit(text);
}

KLListBox *klListBox()
{
  return new KLListBox();
}

KLHVSpace *klHVSpace()
{
  return new KLHVSpace();
}

KLHVGroup &klHGroup(KLHVGroup **ppgroup = 0)
{
  KLHVGroup *group = new KLHVGroup(true);
  if( ppgroup ) 
    *ppgroup = group;
  return *group;
}

KLHVGroup &klVGroup(KLHVGroup **ppgroup)
{
  KLHVGroup *group = new KLHVGroup(false);
  if( ppgroup ) 
    *ppgroup = group;
  return *group;
}

KLGroupBox &klGroupBox(const char *title,bool horiz, KLGroupBox **ppgroup)
{
  KLGroupBox *group = new KLGroupBox(title,horiz);
  if( ppgroup ) 
    *ppgroup = group;
  return *group;
}


KLGridGroup &klGridGroup(ulong rowColCount, bool rowGrid,KLGridGroup **ppgroup)
{
  KLGridGroup *group = new KLGridGroup(rowColCount,rowGrid);
  if( ppgroup ) 
    *ppgroup = group;
  return *group;
}

#define REGCLASS(classname) reglist->regMetaClass(&classname::metaClass)
void klRegisterCommonClasses(KLMetaRegList *reglist)
{
  // Groups
  REGCLASS(KLGridGroup);
  REGCLASS(KLPageGroup);
  REGCLASS(KLHVGroup);

  // Tools
  REGCLASS(KLHVSpace);
  REGCLASS(KLReplaceMe);

  // Widgets
  REGCLASS(KLGroupBox);
  REGCLASS(KLLabel);
  REGCLASS(KLButton);
  REGCLASS(KLCheckBox);
  REGCLASS(KLLineEdit);
  REGCLASS(KLMultiLineEdit);
  REGCLASS(KLListBox);
}
