/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLCOMBOBOX_H
#define KLCOMBOBOX_H

#include "klwidgetbase.h"
#include "qcombo.h"

class KLComboBox : public QComboBox, public KLWidgetBase {
  Q_OBJECT
public:
  /**
  * Creates a combobox with motif look and feel
  */
  KLComboBox();
  /**
  * Creates a combobox with motif 2.0 or Windows look and feel
  */
  KLComboBox(bool rw);
  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);

  KLWDIGET_DELEGATES(KLComboBox,QComboBox);
};

#endif 

