
#include "pagingwin.h"
#include "klcombobox.h"

KLSimplePage::KLSimplePage() : KLHVGroup(false)
{
  KLComboBox *mycombo;
  KLComboBox *mycombo2;
  *this << (*(new KLHVGroup(false))
           << (*(pagegroup = new KLTabGroup())
              << "Page 1"
              << (*(new KLGroupBox("Page 1",true)) 
                 << new KLLabel("Label on page1")
                 << new KLCheckBox("Sure, this is page 1 ?"))
              << "Page 2"
              << (*(new KLGroupBox("Page 2",false))
                 << new KLLineEdit("Edit on Page 2")
                 << (listbox = new KLListBox()))
              << "Page 3"
              << (*(new KLGroupBox("Page 3",false))
                 << new KLCheckBox("Check 1")
                 << new KLCheckBox("Check 2")
                 << new KLCheckBox("Check 3"))
              << "This is the page 4 ..."
              << (*(new KLTabGroup())
                 << "SubPage 1"
                 << new KLListBox()
                 << "SubPage 2"
                 << (*(new KLHVGroup(true))
                    << (*(new KLGroupBox("Page Radios"))
                       << new KLRadioButton("Logical Page 1",&rm,0)
                       << new KLRadioButton("Logical Page 2",&rm,1)
                       << new KLRadioButton("Logical Page 3",&rm,2)
                       << ::setWeight << 1)
                    << (*(subpage = new KLPageGroup(KLPageGroup::ActMax)) // I think, this will look more nice
                      << (*(new KLHVGroup(false))
                         << new KLLabel("This is just a text standing on\nthe first logical page.\n"
                                        "It has a fix size.\n(As you can see ...)\n")
                         << new KLCheckBox("not of interest to me"))
                      << (*(new KLGroupBox("Just a group box",false))
                         << new KLLineEdit("This is just a small edit ...")
                         << new KLCheckBox("nice page"))
                      << (*(new KLTabGroup())
                         << "An other Page"
                         << new KLLabel("This is just some text to make\nthis group bigger than\n"
                                        "the group with the radiobuttons\n\nIt just should show\n"
                                        "the dynamic resizing and repositioning\nof the group\n"
                                        "and all other things. Is this enough text\nto fill up the complete\n"
                                        "group ? Well see ...")
                         << "Now again -- a Page"
                         << (*(new KLHVGroup(false))
                            << (*(new KLHVGroup(true))
                               << new KLRadioButton("Radio 1",&rm2)
                               << new KLRadioButton("Radio 2",&rm2)
                               << (mycombo2 = new KLComboBox(true)))
                            << (*(new KLHVGroup(true))
                               << new KLRadioButton("Radio 3",&rm2)
                               << (mycombo = new KLComboBox())
                               << new KLRadioButton("Radio 4",&rm2))))))))
           << (*(new KLHVGroup(true))
              << ::setSameSize
              << (but1 = new KLButton("Page 1")) 
              << (but2 = new KLButton("Page 2"))
              << (but3 = new KLButton("Page 3"))
              << (but4 = new KLButton("Page 4"))
              << new KLHVSpace()
              << (nice = new KLButton("Nice Tabs"))));
  
  connect(but1,SIGNAL(clicked()),this,SLOT(onBut1()));
  connect(but2,SIGNAL(clicked()),this,SLOT(onBut2()));
  connect(but3,SIGNAL(clicked()),this,SLOT(onBut3()));
  connect(but4,SIGNAL(clicked()),this,SLOT(onBut4()));
  connect(nice,SIGNAL(clicked()),this,SLOT(createNice()));
  connect(&rm,SIGNAL(clicked(int)),this,SLOT(changePage(int)));
  rm.setChecked(0L);
  rm2.setChecked(0L);
  mycombo->insertItem("Combo Entry 1");
  mycombo->insertItem("Combo Entry 2");
  mycombo->insertItem("Combo Entry 3");
  mycombo2->insertItem("Combo Entry 1");
  mycombo2->insertItem("Combo Entry 2");
  mycombo2->insertItem("Combo Entry 3");
}


void KLSimplePage::changePage(int n)
{
  subpage->setActPage(n);
}


void KLSimplePage::onBut1()
{
  pagegroup->setActPage(0);
}


void KLSimplePage::onBut2()
{
  pagegroup->setActPage(1);

  listbox->setStyle(WindowsStyle);
  //listbox->setStyle(MotifStyle);

}


void KLSimplePage::onBut3()
{
  pagegroup->setActPage(2);
}


void KLSimplePage::onBut4()
{
  pagegroup->setActPage(3);
}


void KLSimplePage::createNice()
{
  KLDialog *dlg = new KLDialog(true);
  KRadioManager *rm = new KRadioManager();    
  KRadioManager *rm2 = new KRadioManager();  
  KLButton *ok;
  KLGroup &group = (*(new KLHVGroup(false))
                   << (*(new KLTabGroup())
                      << "Main"
                      << (*(new KLHVGroup(false))
                         << (*(new KLGroupBox("User Information",false))
                           << (*(new KLGridGroup(2,false))
                              << new KLLabel( "User Name:" )
                               << new KLLineEdit()
                              << (*(new KLLabel( "Sex:" )) << ::setWeight << 1)
                               << (*(new KLHVGroup(true))
                                  << new KLRadioButton("male",rm2)
                                  << new KLRadioButton("female",rm2)
                                  << new KLHVSpace()) // Should eat the rest of the avaible space
                              << (*(new KLLabel( "Age:" )) << ::setWeight << 1)
                               << new KLLineEdit()
                              << (*(new KLLabel( "E-Mail:" )) << ::setWeight << 1)
                               << new KLLineEdit()))
                         << new KLHVSpace())
                      << "GUI settings"
                      << (*(new KLHVGroup(false))
                        << (*(new KLGroupBox("GUI settings",true))
                           << (*(new KLHVGroup(false))
                             << (*(new KLGroupBox("GUI Style",false))
                                << new KLRadioButton("Windows 95",rm)
                                << new KLRadioButton("Motif 2.0",rm))
                                << new KLHVSpace()
                                << ::setYWeight << 0 ) // Setting a weight of 0 means: Show only your minsizes and notting more !
                           << (*(new KLGroupBox("Font",false))
                              << (*(new KLHVGroup(true))
                                << new KLLabel("Font:")
                                << new KLComboBox(true)
                                << new KLLabel("Size:")
                                << new KLComboBox(true))
                              << (*(new KLHVGroup(true))
                                 << new KLLabel("Preview:")
                                 << new KLHVSpace())
                              << new KLListBox())) // Listview: Fake a font preview 
                        << (*(new KLHVSpace()) << ::setFixXSize << 20)
                        << (*(new KLHVGroup(true))
                           << new KLHVSpace()
                           << (*(new KLGroupBox("Description",true))
                              << new KLLabel("","info.xpm",KLLabel::Image)
                              << new KLLabel("This is a small page,\njust to show that\n"
                                             "nice looking GUIs are\nrealy no problem."))
                           << new KLHVSpace())
                        << (*(new KLHVSpace()) << ::setFixXSize << 20))
                      << "QLayout demo fake"
                      << (*(new KLHVGroup(false))
                         << (*(new KLHVGroup(true))
                            << ::setSameSize
                            << new KLButton("Button 1")
                            << new KLButton("Button 2")
                            << new KLButton("Button 3")
                            << new KLButton("Button 4"))
                         << (*(new KLHVGroup(true))
                           << (*(new KLHVGroup(true))
                              << new KLButton("Button five")
                              << new KLButton("Button 6")
                              << ::setWeight << 0)
                           << new KLHVSpace())
                         << (*(new KLGroupBox("",false))
                            << new KLHVSpace()
                            << (*(new KLHVGroup(true))
                               << new KLLabel("This widget will get all the remaining space")
                               << new KLHVSpace())
                            << new KLHVSpace())
                         << (*(new KLHVGroup(true))
                            << (*(new KLHVGroup(false))
                               << (*(new KLHVGroup(true))
                                  << new KLLabel("Line 1")
                                  << new KLLineEdit(""))
                               << (*(new KLHVGroup(true))
                                  << new KLLabel("Line 2")
                                  << new KLLineEdit(""))
                               << (*(new KLHVGroup(true))
                                  << new KLLabel("Line 3")
                                  << new KLLineEdit("")))
                            << new KLMultiLineEdit()))) // Sorry, no multiline edit (yet)
                   << (*(new KLHVGroup(true))
                      << ::setSameSize
                      << new KLButton("Help")
                      << new KLButton("Defaults")
                      << new KLHVSpace()
                      << new KLHVSpace()
                      << (ok = new KLButton("&Ok"))
                      << new KLButton("&Apply")
                      << new KLButton("&Cancel")));
  rm->setChecked(0l); // 0L -> otherwise the compiler will not find the right function
  rm2->setChecked(0l);
  ok->setDefault(true);
  dlg->setRootChild(&group); 
  dlg->exec();
  delete rm;
  delete rm2;
  delete dlg;
}


int main( int argc, char **argv ) 
{
  {
    KApplication app(argc,argv);
    KLDialog dlg;
    KLGroup &group = (*(new KLHVGroup(false))
                       << (*(new KLHVGroup(true))
                          << new KLHVSpace()
                          << new KLLabel("This example just shows some pages and tabcontrols ...")
                          << new KLHVSpace())
                       << new KLSimplePage());
        
    dlg.setRootChild(&group);
    dlg.show();
    app.setMainWidget( &dlg );
    app.exec();
  }
}

#include "pagingwin.moc"
