#!/usr/bin/env ruby
#
# Ruby script for preparing libkdcraw releases from KDE SVN
#
# (c) 2006 Angelo Naselli <anaselli at linux dot it>
# 
# License: GNU General Public License V2

name       = "libkdcraw"
egmodule   = "libs"
version    = "0.1.0"
version_n  = "0x000100"
t          = Time.now
date       = t.strftime("%Y-%m-%d")

# modify libkdcraw.lsm
old_file   = name + "/" + name + ".lsm"
new_file   = name + "/" + name + ".lsm.new"

old = File.open(old_file)
new = File.open(new_file, "w")
while old.gets do
    fileLine = $_
    if (fileLine.index("Version") )
      new.print  "Version: " + version + "\n"
    elsif (fileLine.index("Entered-date") )
      new.print  "Entered-date: " + date + "\n"
    else
      new.print  fileLine
    end
end
old.close
new.close
File.rename(old_file, "old.orig")
File.rename(new_file, old_file)

# modify libkdcraw/version.h
old_file   = name + "/version.h"
new_file   = name + "/version.h.new"

old = File.open(old_file)
new = File.open(new_file, "w")
while old.gets do
    fileLine = $_
    if (fileLine.index("kipi_version") )
      new.print  "static const char kipi_version[] = \"" + version + "\";\n"
    elsif (fileLine.index("KIPI_VERSION") )
       if (fileLine.index("0x"))
         new.print  "#define KIPI_VERSION " + version_n +"\n"
       else
         new.print  fileLine
       end
    else
      new.print  fileLine
    end
end
old.close
new.close
File.rename(old_file, "old.orig")
File.rename(new_file, old_file)

# modify libkdcraw/libkdcraw.pc.in
old_file   = name + "/" + name + ".pc.in"
new_file   = name + "/" + name + ".pc.in.new"

old = File.open(old_file)
new = File.open(new_file, "w")
while old.gets do
    fileLine = $_
    if (fileLine.index("Version") )
      new.print  "Version: " + version + "\n"
    else
      new.print  fileLine
    end
end
old.close
new.close
File.rename(old_file, "old.orig")
File.rename(new_file, old_file)


