/***************************************************************************
                          camera_folder.cpp  -  description
                             -------------------
    begin                : Thu Dec 31 12:00:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <klistview.h>

#include <qstring.h>

#include "camera_folder.h"
#include "camera_iconview.h"


Camera_Folder::Camera_Folder(KListView *parent, QString folderPath,
			     QString name): KListViewItem(parent) {

    numSubFolders=0;
    numImages=0;

    path = folderPath;
    folderName = name;



    setText(0,folderName);
    //setPixmap(0,BarIcon("folder"));

    KIconLoader iconLoader;
    setPixmap(0,iconLoader.loadIcon("folder",KIcon::Desktop));

    m_iconView = NULL;

}

Camera_Folder::Camera_Folder(KListViewItem *parent, QString folderPath,
			     QString name): KListViewItem(parent) {

    numSubFolders=0;
    numImages=0;

    path = folderPath;
    folderName = name;

    setText(0,folderName);
    // setPixmap(0,BarIcon("folder"));

    KIconLoader iconLoader;
    setPixmap(0,iconLoader.loadIcon("folder",KIcon::Desktop));

    m_iconView = NULL;
}

Camera_Folder::~Camera_Folder(){

    if (m_iconView) {
        delete m_iconView;
        m_iconView = NULL;
    }

}

QString Camera_Folder::getPath() const{
    return path;
}


void Camera_Folder::showText() {
    QString numImagesString;
    setText(0, folderName +  " (" + numImagesString.setNum(numImages) + ")" );
}


QString Camera_Folder::getName() const{
    return folderName;
}



void Camera_Folder::setOpen(bool flag) {

  KIconLoader iconLoader;
  
  if (flag)
    //setPixmap(0,BarIcon("folder_open"));
    setPixmap(0,iconLoader.loadIcon("folder_open",KIcon::Desktop));    
  else
    //setPixmap(0,BarIcon("folder"));
    setPixmap(0,iconLoader.loadIcon("folder",KIcon::Desktop));
  QListViewItem::setOpen(flag);

}

void Camera_Folder::setNumSubFolders(const int count) {
    numSubFolders=count;
}

void Camera_Folder::setNumImages(const int count) {
    numImages=count;
    showText();
}

int Camera_Folder::getNumSubFolders() {
    return  numSubFolders;
}

int Camera_Folder::getNumImages() {
    return  numImages;
}


