/***************************************************************************
                          photo_folder.cpp  -  description
                             -------------------
    begin                : Sun Jan 13 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qfileinfo.h>
#include <qdir.h>

#include <kiconloader.h>
#include <kfileitem.h>
#include <kurl.h>

#include "photo_folder.h"
#include "photo_foldertree.h"

Photo_Folder::Photo_Folder(KListView* parent, KFileItem* item):
  KListViewItem(parent)
{
  fileItem = item;
  KURL url = item->url();
  QString folderName = url.fileName();
  setText(0, folderName);
  setPixmap(0, SmallIcon("folder"));
  
  oldURL = url;
}

Photo_Folder::Photo_Folder(KListViewItem* parent, KFileItem* item):
  KListViewItem(parent)
{
  fileItem = item;
  KURL url = item->url();
  QString folderName = url.fileName();
  setText(0, folderName);
  setPixmap(0, SmallIcon("folder"));

  oldURL = url;
}



Photo_Folder::~Photo_Folder(){
}

void Photo_Folder::setOpen(bool open) {

  bool isHomeDir= false;
  if (getURL().cmp(KURL(QDir::homeDirPath()), true))
    isHomeDir = true;

  if (open)  {
    if (!isHomeDir)
      setPixmap(0, SmallIcon("folder_open"));
  }
  else {
    if (!isHomeDir)
      setPixmap(0,SmallIcon("folder"));    
  }

  QListViewItem::setOpen(open);

}

KFileItem* Photo_Folder::getFileItem() {
  return fileItem;
}

KURL Photo_Folder::getURL() {
  return fileItem->url();
}

void Photo_Folder::refreshItem() {

  QString folderName = fileItem->url().fileName();
  setText(0, folderName);
  oldURL = fileItem->url();
}
