#include "exif_parser.h"
#include "tagFunctions.h"

knowntag IFD0_tags[] = {
  {0x010e,     "Image Description", tagString, 0},
  {0x010f,     "Make",              tagString, 0},
  {0x0110,     "Model",             tagString, 0},
  {0x0112,     "Orientation",       tagOrientation, 0},
  {0x011a,     "X Resolution",      tagRationalNormal, " Pixels/Inch"},
  {0x011b,     "Y Resolution",      tagRationalNormal, " Pixels/Inch"},
  {0x0128,     "Resolution Unit",   tagResolutionUnit, 0},
  {0x0131,     "SoftWare",          tagString, 0},
  {0x0132,     "Date & Time",       tagString, 0},
  {0x013e,     "WhitePoint",        tagWhitePoint, 0},
  {0x013f,     "Primary Chromacities",  tagPrimaryChromacities, 0},
  {0x0211,     "YCbCr Coefficients",    tagYCbCrCoefficients, 0},
  {0x0213,     "YCbCr Positioning",     tagYCbCrPositioning, 0},
  {0x0214,     "Reference Black/White",  tagReferenceBW, 0},
  {0x8298,     "Copyright",              tagString, 0},
  {0x8769,     "Offset to Exif Sub IFD", 0, 0},
};


knowntag subIFD_tags[] = {
  {0x829a,     "Exposure Time",             tagRational,         " seconds"},
  {0x829d,     "F-Number",                  tagRational,         0},
  {0x8822,     "Exposure Program",          tagExpProgram,       0},
  {0x8827,     "ISO Speed Rating",          tagISO,              0},
  {0x9000,     "Exif Version",              tagExifVersion,      0},
  {0x9003,     "Date & Time Original",      tagString,		 0},
  {0x9004,     "Date & Time Digitized",     tagString,		 0},
  {0x9101,     "Components Configuration",  0,			 0},
  {0x9102,     "Compressed Bits Per Pixel", tagRationalNormal,	 0},
  {0x9201,     "Shutter Speed",             tagShutterSpeed ,    " seconds"},
  {0x9202,     "Aperture",                  tagAperture,         0},
  {0x9203,     "Brightness",                tagRationalNormal,         " EV"},
  {0x9204,     "Exposure Bias",             tagRationalNormal,         " EV"},
  {0x9205,     "Max Aperture",              tagAperture,         0},
  {0x9206,     "Subject Distance",          tagRationalNormal,  " meters"},
  {0x9207,     "Metering Mode",             tagMeteringMode,     0},
  {0x9208,     "Light Source/White Balance", tagLightSource,     0},
  {0x9209,     "Flash",                     tagFlash,            0},
  {0x920a,     "Focal Length",              tagRationalNormal,         " mm"},
  {0x927c,     "Maker Note",                0,                   0},
  {0x9286,     "User Comment",              tagString,           0},
  {0x9290,     "SubsecTime",                tagString,           0},
  {0x9291,     "SubsecTime Original",       tagString,           0},
  {0x9292,     "SubsecTime Digitized",      tagString,           0},
  {0xa000,     "FlashPix Version",          tagExifVersion,           0},
  {0xa001,     "ColorSpace",                tagUShort,           0},
  {0xa002,     "Image Width",               tagNumber,           " Pixels"},
  {0xa003,     "Image Height",              tagNumber,           " Pixels"},
  {0xa004,     "Related Sound File",        tagString,           0},
  {0xa005,     "ExifInteroperabilityOffset", 0, 0},
  {0xa20e,     "Focal Plane X Resolution",  tagRationalNormal,   " Pixels/Inch"},
  {0xa20f,     "Focal Plane Y Resolution",  tagRationalNormal,   " Pixels/Inch"},
  {0xa210,     "Focal Plane Resolution Unit", tagResolutionUnit,         0},
  {0xa215,     "Exposure Index",              tagRationalNormal, 0},
  {0xa217,     "Sensing Method",              tagSensingMethod,  0},
  {0xa300,     "File Source",                tagFileSource, 0},
  {0xa301,     "Scene Type",                 tagSceneType, 0},
};


knowntag IFD1_tags[] = {
  
  {0x0100, "Thumbnail Image Width",  tagNumber, " Pixels"},
  {0x0101, "Thumbnail Image Height", tagNumber, " Pixels"},
  {0x0102, "Bits per Sample", tagUShort, 0},
  {0x0103, "Compression", tagCompression, 0},
  {0x0106, "Photometric Interpretation", tagPhotoMetric, 0},
  {0x0111, "Strip Offsets", tagNumber, 0},
  {0x0112, "Orientation", tagOrientation, 0},
  {0x0115, "Samples Per Pixel", tagUShort, 0},
  {0x0116, "Rows Per Strip", tagNumber, 0},
  {0x0117, "Strip Byte Count", tagNumber, 0},
  {0x011a, "X Resolution", tagRationalNormal, " Pixels/Inch"},
  {0x011b, "Y Resolution", tagRationalNormal, " Pixels/Inch"},
  {0x011c, "Planar Configuration", 0, 0}, // Edit
  {0x0128, "Resolution Unit",   tagResolutionUnit, 0},
  {0x0201, "JpegIF Offset", tagULong, 0},
  {0x0202, "JpegIF Byte Count", tagULong, 0},
  {0x0211, "YCbCr Coefficients",    tagYCbCrCoefficients, 0},
  {0x0212, "YCbCr SubSampling", tagUShort, 0},
  {0x0213, "YCbCr Positioning",     tagYCbCrPositioning, 0},
  {0x0214, "Reference Black/White",  tagReferenceBW, 0},
};

knowntag interIFD_tags[] = {

  {0x0001, "InterOperability Index", tagString, 0},
  {0x0002, "InterOperability Version", tagExifVersion, 0},
  {0x1000, "Related Image File Format", tagString, 0},
  {0x1001, "Related Image Width", tagNumber, " Pixels"},
  {0x1002, "Related Image Height", tagNumber, " Pixels"},
  {0, 0, 0, 0},
};

knowntag nikon_tags[] = {
  {0x0001, "Nikon Version Number", tagNikonVersion, 0},
  {0x0002, "ISO Equivalent", tagISO, 0},
  {0x0003, "Color/BW", tagString, 0},
  {0x0004, "Quality", tagString, 0},
  {0x0005, "White Balance", tagString, 0},
  {0x0006, "Sharpening", tagString, 0},
  {0x0007, "Focus", tagString, 0},
  {0x0008, "Flash Mode", tagString, 0},
  {0x0009, "Flash Metering mode", tagString, 0},
  {0x000a, "Unknown", 0, 0},
  {0x000b, "White Balance Adjustment", tagUShort, 0},
  {0x000f, "ISO Selection",  tagString, 0},
  {0x0011, "Unknown",  0, 0},
  {0x0080, "Image Adjustment",  tagString, 0},
  {0x0081, "Unknown",  0, 0},
  {0x0082, "Adapter", tagString, 0},
  {0x0085, "Manual Focus Distance", tagRational, " meters"},
  {0x0086, "Digital Zoom", tagRationalNormal, 0},
  {0x0088, "AF Focus Position", tagNikonAFFocusPosition, 0},
  {0x008f, "Unknown",  0, 0},
};

knowntag olympus_tags[] = {
  {0x0200, "Special Mode", tagOlympusSpecialMode, 0},
  {0x0201, "Jpeg Quality", tagOlympusJpegQuality, 0},
  {0x0202, "Macro Mode",   tagOlympusMacro, 0},
  {0x0204, "Digital Zoom", tagRationalNormal, 0},
  {0x0207, "SoftWare Release", tagExifVersion, 0},
  {0x0208, "Picture Info", tagString, 0},
  {0x0209, "Camera ID", tagExifVersion, 0},
};
