/***************************************************************************
                          camera_iconview.h  -  description
                             -------------------
    begin                : Sat Jan 5 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CAMERA_ICONVIEW_H
#define CAMERA_ICONVIEW_H

#include <kiconview.h>

class QString;
class QPixmap;

class Camera_IconView : public KIconView  {

 public: 
  Camera_IconView(QWidget* parent);
  ~Camera_IconView();

  
};


class Camera_IconViewItem : public QIconViewItem {
  
public:

  Camera_IconViewItem(Camera_IconView* parent);
  ~Camera_IconViewItem();

  bool isThumbNailed();
  void setThumbNail(QPixmap* icon);
  void setThumbNail();

  void setMimeType(const QString& mime);
  QString getMimeType();
  void setPixmapForMime();

  void setCameraFolder(const QString& folder);
  QString getCameraFolder();

  // Points to the correspoding item in global folder
  // The item in global folder points to corresponding
  // item in the actual folder
  Camera_IconViewItem* itemInGlobal;
    
  
private:

  bool  thumbNailed;
  QPixmap *thumbNail;

  QString mimeType;
  QString cameraFolder;

};

#endif
