/***************************************************************************
                          digikam.h  -  description
                             -------------------
    begin                : Thu Dec 20 12:40:20 CST 2001
    copyright            : (C) 2001 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIGIKAM_H
#define DIGIKAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kstatusbar.h>
#include <kprogress.h>

#include <qmap.h>
#include <qstringlist.h>

#include "digikam_mainwindow.h"


extern "C" {
	#include <gphoto2.h>
}


/** Digikam is the base class of the project */
class Digikam : public Digikam_MainWindow
{
  Q_OBJECT 

  public:

    Digikam(QWidget* parent=0, const char *name=0);

    ~Digikam();


    protected slots:

      void slot_connectToCamera();
      void slot_selectAll();
      void slot_downloadImages();
      //void slot_help();
      void slot_setup();
      void slot_close();
      void slot_browse();


 private:

    static QMap<Camera *, Digikam *> my_cameraMap;
    static void debug_func (GPLogLevel level, const char *domain, const char *format,
			    va_list args, void *data);
    static void status_func (Camera *camera, const char *status, void *data);
    static void message_func (Camera *camera, const char *message, void *data);
    static void progress_func (Camera *camera, float percentage, void *data);

    void initGlobals();
    int  initCamera();
    void getFolderNames(QString folder);
    void getThumbNails();
    void updateThumbNails();

    Camera *my_camera;
    QString my_cameraModel;
    QString my_cameraPort;
    QString my_cameraPortPath;
    QString my_cameraFolder;
    QStringList my_cameraFolderList;
    int my_cameraNumFolders;

    QString globTempDir;

    void setStatusMsg(const QString &);
    void setStatusTempMsg(const QString &);
    void setProgressValue(int progress);

    KStatusBar *statusBar;
    KProgress  *progressBar;

    bool my_cameraInitialised;

};

#endif
