/***************************************************************************
                          ksteakiface.h  -  description
                             -------------------
    begin                : Wed Apr 25 2001
    copyright            : (C) 2001 by Michael Heidecke
    email                : heidecke@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTEAKIFACE_H
#define KSTEAKIFACE_H

#include <dcopobject.h>

/**
 * Abstract base class to be implemented as KSteaks DCOP interface.
 * @short DCOP interface
 * @author Olaf Hartig
 */
class KSteakIface : virtual public DCOPObject
{
	K_DCOP

	k_dcop:
		/** Translates the given word/phrase. If szWord is empty, translates the current clipboard contents. */
		virtual void translate(const QString & szWord) = 0;
		/** Docks KSteak to system tray. */
		virtual void dock() = 0;
		/** Undocks KSteak from system tray. */
		virtual void undock() = 0;
};

#endif
