/***************************************************************************
                                kstdebug.cpp
                             -------------------
    begin                : Mar 07 2004
    copyright            : (C) 2004 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kstdatasource.h"
#include "kstdebug.h"

#include <kapplication.h>
#include <klocale.h>
#include <qdatetime.h>

KStaticDeleter<KstDebug> sd;

KstDebug *KstDebug::self() {
  if (!_self) {
    _self = sd.setObject(_self, new KstDebug);
  }

  return _self;
}


KstDebug::KstDebug() {
}


KstDebug::~KstDebug() {
}


KstDebug *KstDebug::_self = 0L;


QStringList KstDebug::dataSourcePlugins() const {
  return KstDataSource::pluginList();
}


void KstDebug::log(const QString& msg, LogLevel level) {
  QString m;

  switch (level) {
    case Notice:
      m = i18n("%1 Notice: %2\n").arg(QDateTime::currentDateTime().toString()).arg(msg);
      break;
    case Warning:
      m = i18n("%1 Warning: %2\n").arg(QDateTime::currentDateTime().toString()).arg(msg);
      break;
    case Error:
      m = i18n("%1 Error: %2\n").arg(QDateTime::currentDateTime().toString()).arg(msg);
      break;
    case Debug:
      m = i18n("%1 Debug: %2\n").arg(QDateTime::currentDateTime().toString()).arg(msg);
      break;
    default:
      m = QDateTime::currentDateTime().toString();
      m += msg;
      m += '\n';
      break;
  }

  _log += m;
  emit logAdded(m);
}


void KstDebug::sendEmail() const {
  QString body;
  body += i18n("Kst log:\n%1\n\n\n").arg(_log);
  body += i18n("Data source plugins:\n");
  QStringList dsp = dataSourcePlugins();
  for (QStringList::ConstIterator i = dsp.begin(); i != dsp.end(); ++i) {
    body += *i;
    body += '\n';
  }
  body += "\n\n\n";

  kapp->invokeMailer(QString::null, QString::null, QString::null, i18n("Kst Debugging Information"), body);
}


#include "kstdebug.moc"
// vim: ts=2 sw=2 et
