/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void DebugDialog::init()
{
    const QStringList& pl = KstDataSource::pluginList();
    for (QStringList::ConstIterator it = pl.begin(); it != pl.end(); ++it) {
	new QListViewItem(_dataSources, *it);
    }
    
    _buildInfo->setText(i18n("<h1>Kst</h1> version %1").arg(KSTVERSION));
    _log->setText(KstDebug::self()->logString());

    connect(KstDebug::self(), SIGNAL(logAdded(const QString&)), _log, SLOT(append(const QString&)));
}


void DebugDialog::show()
{
    _log->scrollToBottom();

    // Inefficient but shouldn't be a factor
    QListViewItemIterator it(_dataSources);
    while (it.current()) {
	while (it.current()->childCount() > 0) {
	    delete it.current()->firstChild();
	}

	for (KstDataSourceList::Iterator i = KST::dataSourceList.begin(); i != KST::dataSourceList.end(); ++i) {
	    if ((*i)->sourceName() == it.current()->text(0)) {
		new QListViewItem(it.current(), QString::null, (*i)->fileName());
	    }
	}
	++it;
    }

    QDialog::show();
}


void DebugDialog::email()
{
    KstDebug::self()->sendEmail();
}
