/***************************************************************************
                          sourcewidget.cpp  -  description
                             -------------------
    begin                : Sun Apr 16 2000
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qtextstream.h>
#include <kglobalsettings.h>
#include "sourcewidget.h"

SourceWidget::SourceWidget(QWidget* _parent, QFile* f) :
 QMultiLineEdit(_parent), line(0), col1(-1), col2(0)
{
  setFont(KGlobalSettings::fixedFont());
  setReadOnly(true);
  setUndoRedoEnabled(false);
  setWordWrap(NoWrap);
  if (f)
    fill(f);
}

SourceWidget::~SourceWidget()
{
}

void SourceWidget::fill(QFile *f)
{
  setAutoUpdate(false);
  clear();
  append(QTextStream(f).read());
  f->close();
  setAutoUpdate(true);
  repaint();
}

void SourceWidget::highlight(const QString& func)
{
  if (func.isEmpty())
    return;
  line = -1;
  while (QString s = textLine(++line)) {
    col1 = s.find(QString(" ") + func + "(double");
    if (col1 != -1) {
      col1++;
      col2 = col1 + func.length();
      slotHighlight();
      break;
    }
  }
  setFocus();
}

void SourceWidget::slotHighlight()
{
  if (col1 > 0) {
    setCursorPosition(line + 15, col1);
    setSelection(line, col1, line, col2);
  }
}
