/***************************************************************************
                          settingsdlg.cpp  -  description
                             -------------------
    begin                : Fr Jun 4 2004
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qfileinfo.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qregexp.h>
#include <qtimer.h>
#include <kaction.h>
#include <kcolorbutton.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "choosefuncdlg.h"
#include "edittextdlg.h"
#include "fitdlg.h"
#include "kpl.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "settingsdlg.h"
#include "sourcewidget.h"
#include "symboldlg.h"
#include "utils.h"

EditFitParameterDlg::EditFitParameterDlg(QWidget* _parent, KplDoc* m,
                                         double* p0, bool* bFit0,
                                         const QString& file,
                                         const QString& func) :
 KDialogBase(Plain, i18n("Fit parameters"), Ok | Cancel, Ok, _parent, 0,
             true, true), bFit(bFit0), p(p0)
{
  QHBoxLayout* hbox = 0;
  QVBoxLayout* vbox;
  QFrame* frame = plainPage();
  if (m->options()->showSource) {
    hbox = new QHBoxLayout(frame, 0, spacingHint());
    vbox = new QVBoxLayout(hbox);
  } else
    vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, frame);
  QGridLayout* grid = new QGridLayout(g->layout(), QMIN(KPL_NPMAX, 10),
                                      2 + 3 * ((KPL_NPMAX - 1) / 10),
                                      spacingHint());
  vbox->addWidget(g);
  QString s;
  char frm = m->options()->format;
  int prec = m->options()->prec;
  int w = 0;
  for (int i = 0; i < KPL_NPMAX; i++) {
    int ix = 3 * (i / 10);
    int iy = i % 10;
    grid->addWidget(enFit[i] = new QCheckBox(s.sprintf("p%i", i), g), iy, ix);
    enFit[i]->setChecked(bFit[i]);
    grid->addWidget(par[i] = new KplDoubleEdit(p[i], g, frm, prec), iy,
                    ix + 1);
    if (!i)
      w = par[0]->fontMetrics().width(m->number(-1.0e-123 / 3.0)) + 3;
    par[i]->setMinimumWidth(w);
  }
  for (int i = 0; i < ((KPL_NPMAX - 1) / 10); i++)
    grid->addItem(new QSpacerItem(20, 10), 0, 3 * i + 2);
  if (m->options()->showSource) {
    QFileInfo fi(file);
    QRegExp rx2("\\S+__FdPCd");
    QRegExp rx3("_Z\\d+\\S+dPKd");
    int pp2 = rx2.search(func);
    int pp3 = rx3.search(func);
    s = fi.dirPath(true) + "/" + fi.baseName();
    bool guessC = pp2 && pp3;
    QFile f(s + (guessC ? ".c" : ".cpp"));
    bool open = f.open(IO_ReadOnly);
    if (!open) {
      f.setName(s + (guessC ? ".cpp" : ".c"));
      open = f.open(IO_ReadOnly);
    }
    if (open) {
      SourceWidget *sw = new SourceWidget(frame, &f);
      hbox->addWidget(sw, 1);
      sw->setMinimumWidth(400);
      if (!pp2)
        sw->highlight(func.left(rx2.matchedLength() - 7));
      else
        if (!pp3)
          sw->highlight(func.mid(3, rx3.matchedLength() - 7));
        else
          sw->highlight(func);
      QTimer::singleShot(0, sw, SLOT(slotHighlight()));
    }
  }
}

EditFitParameterDlg::~EditFitParameterDlg()
{
}

void EditFitParameterDlg::slotOk()
{
  for (int i = 0; i < KPL_NPMAX; i++) {
    p[i] = par[i]->value();
    bFit[i] = enFit[i]->isChecked();
  }
  accept();
}

const double SettingsDlg::xSize[] = {84.1, 118.9, 59.7, 84.1, 42.0, 59.7,
                                     29.7, 42.0, 21.0, 29.7, 14.8, 21.0,
                                     21.59, 27.94};
const double SettingsDlg::ySize[] = {118.9, 84.1, 84.1, 59.7, 59.7, 42.0,
                                     42.0, 29.7, 29.7, 21.0, 21.0, 14.8,
                                     27.94, 21.59};

SettingsDlg::SettingsDlg(QWidget* parent, KplDoc* m0) :
 KDialogBase(IconList, i18n("Kpl Settings"),
             Help | Ok | Apply | Cancel | User1, Ok, parent, 0, true, true,
             i18n("&Save Settings")),
 m(m0)
{
  app = (Kpl*) parent;
  a = KplNamespace::AutoStruct(*m->options());
  QFrame* frame = addPage(i18n("Basic settings"), i18n("Basic settings"),
                          BarIcon("misc", KIcon::SizeMedium));
  QHBoxLayout* hbox2 = new QHBoxLayout(frame, 0, spacingHint());
  QVBoxLayout* vbox = new QVBoxLayout(hbox2, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Page format "), frame);
  vbox->addWidget(g);
  QVBoxLayout* vbox2 = new QVBoxLayout(g->layout(), spacingHint());
  vbox2->addWidget(format = new QComboBox(false, g));
  QStringList list;
  list << i18n("Portrait A0") << i18n("Landscape A0")
       << i18n("Portrait A1") << i18n("Landscape A1")
       << i18n("Portrait A2") << i18n("Landscape A2")
       << i18n("Portrait A3") << i18n("Landscape A3")
       << i18n("Portrait A4") << i18n("Landscape A4")
       << i18n("Portrait A5") << i18n("Landscape A5")
       << i18n("Portrait Letter") << i18n("Landscape Letter")
       << i18n("Custom");
  format->insertStringList(list);
  QHBoxLayout* hbox = new QHBoxLayout(vbox2, spacingHint());
  hbox->addWidget(new QLabel(i18n("Width"), g));
  hbox->addWidget(formatx = new KplDoubleEdit(a.xf, 0.5, 200.0, g));
  hbox->addWidget(new QLabel("cm", g));
  hbox->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding));
  hbox->addWidget(new QLabel(i18n("Height"), g));
  hbox->addWidget(formaty = new KplDoubleEdit(a.yf, 0.5, 200.0, g));
  hbox->addWidget(new QLabel("cm", g));
  int i;
  lFormat = sizeof(xSize) / sizeof(double);
  for (i = 0; i < lFormat; i++)
    if ((xSize[i] == a.xf) && (ySize[i] == a.yf)) {
      formatx->setEnabled(false);
      formaty->setEnabled(false);
      break;
    }
  format->setCurrentItem(i);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Default colors"),
                                    frame));
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("Frame"), g), 0, 0);
  grid->addWidget(colFrame = new KColorButton(QColor(a.colFrame), g),
                  0, 1);
  grid->addWidget(new QLabel(i18n("Grid"), g), 1, 0);
  grid->addWidget(colGrid = new KColorButton(QColor(a.colGrid), g), 1, 1);
  grid->addWidget(new QLabel(i18n("Data"), g), 2, 0);
  grid->addWidget(colData = new KColorButton(QColor(a.colData), g), 2, 1);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Input format"),
                                    frame));
  grid = new QGridLayout(g->layout(), 1, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("Decimal symbol"), g), 0, 0);
  grid->addWidget(deci = new QComboBox(false, g), 0, 1);
  list.clear();
  list << "." << ",";
  deci->insertStringList(list);
  deci->setCurrentItem(a.iDec);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Output format"),
                                    frame));
  grid = new QGridLayout(g->layout(), 3, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("Presentation"), g), 0, 0);
  grid->addWidget(pres = new QComboBox(false, g), 0, 1);
  const char* items[] = {"e", "E", "f", "g", "G", 0};
  pres->insertStrList(items);
  for (i = 0; i < 5; i++)
    if (*items[i] == a.format)
      break;
  pres->setCurrentItem(i);
  grid->addWidget(new QLabel(i18n("Precision"), g), 1, 0);
  grid->addWidget(prec = new KplSpinBox(0, 0, 1, g), 1, 1);
  prec->setRange(1, 30);
  prec->setValue(a.prec);
  grid->addWidget(sep = new QComboBox(false, g), 2, 1);
  list.clear();
  list << i18n("Space") << i18n("Tab") << ",";
  sep->insertStringList(list);
  sep->setCurrentItem(a.iSep);
  grid->addWidget(new QLabel(sep, i18n("Separator"), g), 2, 0);
  hbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Options"), frame),
                   0, 0);
  vbox2 = new QVBoxLayout(g->layout(), 16);
  vbox2->addWidget(showSource = new QCheckBox(i18n("Show function source"),
                   g));
  showSource->setChecked(a.showSource);
  vbox2->addWidget(autoPlot = new QCheckBox(i18n("Autoplot"), g));
  autoPlot->setChecked(app->autoPlot->isChecked());
  vbox2->addWidget(autoFit = new QCheckBox(i18n("Autofit"), g));
  autoFit->setChecked(a.autoFit);
  vbox2->addWidget(addData = new QCheckBox(i18n("Add files"), g));
  addData->setChecked(a.addData);
  connect(format, SIGNAL(activated(int)), SLOT(slotFormatChanged(int)));
  vbox2->addWidget(boundingBox =
                   new QCheckBox(i18n("Calculate PS bounding box"), g));
  boundingBox->setChecked(app->boundingBox->isChecked());
  vbox2->addWidget(printPS = new QCheckBox(i18n("Print PS output"), g));
  printPS->setChecked(app->printPS->isChecked());
  vbox2->addWidget(saveAbsPath = new QCheckBox(i18n("Save absolute paths"),
                                               g));
  saveAbsPath->setChecked(app->saveAbsPath->isChecked());
  vbox2->addWidget(warning = new QCheckBox(i18n("Unsaved changes warning"),
                                           g));
  warning->setChecked(app->warning->isChecked());
  vbox2->addWidget(saveAtEnd = new QCheckBox(i18n("Save settings at end"), g));
  saveAtEnd->setChecked(app->saveAtEnd->isChecked());
  frame = addPage(i18n("Autoplot settings"), i18n("Autoplot settings"),
                  BarIcon("kpl", KIcon::SizeMedium));
  vbox = new QVBoxLayout(frame, 0, spacingHint());
  hbox = new QHBoxLayout(vbox);
  hbox->addWidget(bg = new QButtonGroup(0, Qt::Vertical, i18n("Axis mode"),
                                        frame), 0, 0);
  vbox2 = new QVBoxLayout(bg->layout(), 16);
  vbox2->addWidget(new QRadioButton(i18n("Frame only"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Tics with numbers"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid"), bg));
  vbox2->addWidget(new QRadioButton(i18n("Grid with numbers"), bg));
  ((QRadioButton*) bg->find(a.autoGrid))->setChecked(true);
  vbox2 = new QVBoxLayout(hbox);
  g = new QGroupBox(0, Qt::Vertical, i18n("Window"), frame);
  vbox2->addWidget(g);
  grid = new QGridLayout(g->layout(), 2, 7, spacingHint());
  grid->addWidget(new QLabel(i18n("Left margin"), g), 0, 0);
  grid->addWidget(autoX0 = new KplDoubleEdit(a.x0Auto, 0.0, 200.0, g), 0, 1);
  grid->addWidget(new QLabel("cm", g), 0, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel(i18n("Width"), g), 0, 4);
  grid->addWidget(autoXl = new KplDoubleEdit(a.xlAuto, 0.5, 200.0, g), 0, 5);
  grid->addWidget(new QLabel("cm", g), 0, 6);
  grid->addWidget(new QLabel(i18n("Bottom margin"), g), 1, 0);
  grid->addWidget(autoY0 = new KplDoubleEdit(a.y0Auto, 0.0, 200.0, g), 1, 1);
  grid->addWidget(new QLabel("cm", g), 1, 2);
  grid->addWidget(new QLabel(i18n("Height"), g), 1, 4);
  grid->addWidget(autoYl = new KplDoubleEdit(a.ylAuto, 0.5, 200.0, g), 1, 5);
  grid->addWidget(new QLabel("cm", g), 1, 6);
  vbox2->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Labels"), frame));
  grid = new QGridLayout(g->layout(), 3, 3, spacingHint());
  grid->addWidget(new QLabel(i18n("x axis"), g), 0, 0);
  grid->addWidget(autoLetX = new QLineEdit(a.sxAuto, g), 0, 1);
  QPushButton *b = new QPushButton("...", g);
  grid->addWidget(b, 0, 2);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetX()));
  grid->addWidget(new QLabel(i18n("y axis"), g), 1, 0);
  grid->addWidget(autoLetY = new QLineEdit(a.syAuto, g), 1, 1);
  grid->addWidget(b = new QPushButton("...", g), 1, 2);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotEditLetY()));
  grid->addWidget(new QLabel(i18n("Heading"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(autohPath = new QCheckBox(i18n("= path"), g));
  autohPath->setChecked(a.autohPath);
  hbox->addWidget(autoLetH = new QLineEdit(a.shAuto, g));
  grid->addWidget(editH = new QPushButton("...", g), 2, 2);
  editH->setFixedWidth(28);
  connect(editH, SIGNAL(clicked()), SLOT(slotEditLetH()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Data"), frame));
  grid = new QGridLayout(g->layout(), 3, 7, spacingHint());
  grid->addWidget(new QLabel(i18n("x column"), g), 0, 0);
  grid->addWidget(ix = new KplSpinBox(0, 19, 1, g), 0, 1);
  ix->setValue(a.ixAuto);
  grid->addWidget(logX = new QCheckBox("log", g), 0, 2);
  logX->setChecked(a.autoLogX);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel(i18n("y column"), g), 1, 0);
  grid->addWidget(iy = new KplSpinBox(0, 19, 1, g), 1, 1);
  iy->setValue(a.iyAuto);
  grid->addWidget(logY = new QCheckBox("log", g), 1, 2);
  logY->setChecked(a.autoLogY);
  grid->addWidget(new QLabel(i18n("Error column"), g), 2, 0);
  grid->addWidget(ie = new KplSpinBox(0, 19, 1, g), 2, 1);
  ie->setValue(a.ieAuto);
  ie->setEnabled(a.autoErr);
  grid->addWidget(err = new QCheckBox(i18n("Error bar"), g), 2, 2);
  err->setChecked(a.autoErr);
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 4);
  grid->addWidget(autoSymb = new KplSpinBox(-17, 9, 1, g), 0, 5);
  autoSymb->setValue(a.autoSymb);
  grid->addWidget(new SymbolButton(g, autoSymb), 0, 6);
  grid->addWidget(new QLabel(i18n("Symbol size"), g), 1, 4);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 5);
  eRelSize->setValue(qRound(100 * a.relSize));
  eRelSize->setSuffix(" %");
  grid->addWidget(autoNorm = new QCheckBox(i18n("Normalization"), g), 2, 4);
  autoNorm->setChecked(a.autoNorm);
  connect(autohPath, SIGNAL(toggled(bool)), SLOT(disableHeading(bool)));
  connect(logX, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  connect(logY, SIGNAL(toggled(bool)), SLOT(slotLogToggled(bool)));
  connect(err, SIGNAL(toggled(bool)), ie, SLOT(setEnabled(bool)));
  connect(autoNorm, SIGNAL(toggled(bool)), SLOT(slotNormToggled(bool)));
  slotLogToggled(a.autoLogX || a.autoLogY);
  disableHeading(a.autohPath);

  frame = addPage(i18n("Autofit settings"), i18n("Autofit settings"),
                  BarIcon("wizard", KIcon::SizeMedium));
  vbox = new QVBoxLayout(frame, 0, spacingHint());
  g = new QGroupBox(0, Qt::Vertical, "y(x)", frame);
  vbox->addWidget(g);
  grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileName = new QLineEdit(a.fitPath, g));
  b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(func = new QLineEdit(a.fitName, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFunc()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameter()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, frame));
  vbox2 = new QVBoxLayout(g->layout(), spacingHint());
  vbox2->addLayout(hbox = new QHBoxLayout());
  vbox2->addWidget(nonLin = new QCheckBox(i18n("Nonlinear fit"), g));
  nonLin->setChecked(a.fitNonLin);
  grid = new QGridLayout(vbox2, 3, 5, 12);
  grid->addWidget(errCol = new QCheckBox(i18n("Error column"), g), 0, 0);
  errCol->setChecked(a.err.fitErrCol);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 1);
  grid->addWidget(errMod = new QPushButton(i18n("Model"), g), 0, 4);
  connect(errMod, SIGNAL(clicked()), SLOT(slotErrMod()));
  grid->addWidget(new QLabel(i18n("Maximum iterations"), g), 1, 0);
  grid->addWidget(sItmax = new KplSpinBox(1, 200, 1, g), 1, 1);
  sItmax->setValue(a.fitMaxIt);
  grid->addWidget(new QLabel(i18n("Tolerance"), g), 1, 3);
  grid->addWidget(eTol = new KplDoubleEdit(a.fitTol, 0.0, 1.0, g, 'g', 6),
                  1, 4);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 0);
  hbox->addWidget(new QLabel(i18n("Symbol"), g));
  hbox->addWidget(symb = new KplSpinBox(-17, 9, 1, g));
  symb->setValue(a.fitSymb);
  grid->addWidget(new SymbolButton(g, symb), 2, 1);
  grid->addWidget(new QLabel(i18n("Color"), g), 2, 3);
  grid->addWidget(colFit = new KColorButton(a.fitColor, g), 2, 4);
  vbox2->addWidget(showDlg = new QCheckBox(i18n("Show dialog"), g));
  showDlg->setChecked(a.fitShowDlg);
  vbox2->addWidget(saveRes = new QCheckBox(i18n("Save parameters"), g));
  saveRes->setChecked(a.fitSavePar);
  vbox2->addWidget(follow = new QCheckBox(i18n("Follow parameters"), g));
  follow->setChecked(a.fitFollow);
  resize(minimumSize());
  setHelp("SEC-SETTINGS");
  connect(errCol, SIGNAL(toggled(bool)), SLOT(disableErrMod(bool)));
  connect(nonLin, SIGNAL(toggled(bool)), SLOT(enableNonLin(bool)));
  disableErrMod(a.err.fitErrCol);
  enableNonLin(a.fitNonLin);
}

SettingsDlg::~SettingsDlg()
{
}

void SettingsDlg::getValues(bool ok)
{
  a.xf = formatx->value();
  a.yf = formaty->value();
  a.colFrame = colFrame->color().rgb();
  a.colGrid = colGrid->color().rgb();
  a.colData = colData->color().rgb();
  a.format = *pres->currentText();
  a.prec = prec->interpretedValue();
  a.iSep = sep->currentItem();
  a.iDec = deci->currentItem();
  a.showSource = showSource->isChecked();
  app->showSource->setChecked(a.showSource);
  a.autoFit = autoFit->isChecked();
  app->autoPlot->setChecked(autoPlot->isChecked());
//  app->slotOptionsAutoPlot();
  a.addData = addData->isChecked();
  app->addData->setChecked(a.addData);
  app->slotOptionsAddData();
  app->boundingBox->setChecked(boundingBox->isChecked());
  app->printPS->setChecked(printPS->isChecked());
  app->saveAbsPath->setChecked(saveAbsPath->isChecked());
  app->warning->setChecked(warning->isChecked());
  app->saveAtEnd->setChecked(saveAtEnd->isChecked());
  a.x0Auto = autoX0->value();
  a.y0Auto = autoY0->value();
  a.xlAuto = autoXl->value();
  a.ylAuto = autoYl->value();
  a.sxAuto = autoLetX->text();
  a.syAuto = autoLetY->text();
  a.shAuto = autoLetH->text();
  a.autohPath = autohPath->isChecked();
  a.autoGrid = bg->id(bg->selected());
  a.ixAuto = ix->interpretedValue();
  a.iyAuto = iy->interpretedValue();
  a.ieAuto = ie->interpretedValue();
  a.autoLogX = logX->isChecked();
  a.autoLogY = logY->isChecked();
  a.autoErr = err->isChecked();
  a.autoSymb = autoSymb->interpretedValue();
  a.relSize = 0.01 * eRelSize->interpretedValue();
  a.autoNorm = autoNorm->isChecked();
  a.fitNonLin = nonLin->isChecked();
  if (a.fitNonLin) {
    a.fitTol = eTol->value();
    a.fitMaxIt = sItmax->interpretedValue();
  }
  a.fitPath = fileName->text();
  a.fitName = func->text();
  a.err.fitErrCol = errCol->isChecked();
  a.fitShowDlg = showDlg->isChecked();
  a.fitSavePar = saveRes->isChecked();
  a.fitFollow = follow->isChecked();
  a.fitColor = colFit->color().rgb();
  a.fitSymb = symb->interpretedValue();
  m->setOptions(&a);
  app->shrink();
  if (ok)
    accept();
}

void SettingsDlg::slotFormatChanged(int i)
{
  bool standard = (i < lFormat);
  formatx->setDisabled(standard);
  formaty->setDisabled(standard);
  if (standard) {
    formatx->setValue(xSize[i]);
    formaty->setValue(ySize[i]);
  }
}

void SettingsDlg::slotEditLetX()
{
  EditTextDlg::editText(this, autoLetX);
}

void SettingsDlg::slotEditLetY()
{
  EditTextDlg::editText(this, autoLetY);
}

void SettingsDlg::slotEditLetH()
{
  EditTextDlg::editText(this, autoLetH);
}

void SettingsDlg::disableHeading(bool off)
{
  autoLetH->setEnabled(!off);
  editH->setEnabled(!off);
}

void SettingsDlg::slotLogToggled(bool state)
{
  if (state)
    autoNorm->setChecked(false);
}

void SettingsDlg::slotNormToggled(bool state)
{
  if (state) {
    logX->setChecked(false);
    logY->setChecked(false);
  }
}

void SettingsDlg::slotFile()
{
  m->getFile(fileName);
}

void SettingsDlg::slotFunc()
{
  QFileInfo fi(fileName->text());
  QString path = fi.dirPath(true);
  QFile f(path + "/" + fi.baseName() + ".def");
  if (f.open(IO_ReadOnly)) {
    ChooseFuncDlg dlg(this, &f, func);
    dlg.exec();
  } else
    KMessageBox::error(this, i18n("while trying to open "
                                  "module definition file"));
}

void SettingsDlg::slotGetParameter()
{
  m->getPar(this, a.pFit);
}

void SettingsDlg::slotEditParameter()
{
  EditFitParameterDlg dlg(this, m, a.pFit, a.fitPar, fileName->text(),
                          func->text());
  dlg.exec();
}

void SettingsDlg::slotSaveParameter()
{
  m->saveFunPar(this, a.pFit);
}

void SettingsDlg::slotErrMod()
{
  ErrModDlg dlg(this, m, &a.err);
  dlg.exec();
}

void SettingsDlg::disableErrMod(bool off)
{
  errMod->setEnabled(!off);
}

void SettingsDlg::enableNonLin(bool on)
{
  eTol->setEnabled(on);
  sItmax->setEnabled(on);
}

void SettingsDlg::slotOk()
{
  getValues(true);
}

void SettingsDlg::slotApply()
{
  getValues(false);
}

void SettingsDlg::slotUser1()
{
  slotApply();
  app->saveOptions(true);
}
