/***************************************************************************
                          imageitem.h  -  description
                             -------------------
    begin                : Don Jun 5 2003
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEITEM_H
#define IMAGEITEM_H

#include <kurl.h>
#include <kplitem.h>

/**
  * Image item class. Class for EPS image items.
  * @author Werner Stille
  */
class ImageItem : public KplItem
{
public: 
  /** Constructor */
  ImageItem();
  /**
    * Constructor. Initializes corresponding to autoplot settings.
    * @param aut pointer to structure containing autoplot settings.
    */
  ImageItem(KplNamespace::AutoStruct* aut);
  /**
    * Constructor. Initializes corresponding to plot file.
    * @param plo pointer to KSimpleConfig object containing item data.
    * @param url URL of plot file.
    */
  ImageItem(KSimpleConfig* plo, const KURL& url);
  /**
    * Constructor. Initializes corresponding to arguments.
    * @param active true for visible item.
    * @param x x position in cm.
    * @param y y position in cm.
    * @param fx x scaling factor.
    * @param fy y scaling factor.
    * @param url URL of EPS file.
    */
  ImageItem(bool active, double x, double y, double fx, double fy,
            const KURL& url);
  /** Destructor */
  ~ImageItem();
  virtual ItemTypes iType() const;
  virtual void draw(KplGraph* g);
#ifndef KPL_CLASSES_ONLY
  virtual void writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                        KplDoc* m) const;
  virtual void setText(QListViewItem* it, bool* arrays, bool* funcs) const;
  virtual int editItem(QWidget* parent, KplDoc* m, int i);
#endif
  virtual KplItem* copy() const;

protected:
  double fx, fy;
  KURL url;

  friend class ImageDlg;
};

#endif
