/***************************************************************************
                          editdlg.h  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITDLG_H
#define EDITDLG_H

#include <kdialogbase.h>

class QTextEdit;

/**
  * Edit dialog class. Simple text editor based on QTextEdit.
  * @author Werner Stille
  */
class EditDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
    * Constructor.
    * @param parent parent widget.
    * @param s initial text.
    * @param ts tab stop width.
    */
  EditDlg(QWidget* parent, QString* s, int ts = 0);
  /** Destructor */
  ~EditDlg();

protected:
  QString* s;
  QTextEdit* edit;

protected slots:
  /** Applies settings and leaves the dialog. */
  virtual void slotOk();
  /** Applies settings without leaving the dialog. */
  virtual void slotApply();
};

#endif
