/***************************************************************************
    kstfit_polynomial_weighted.cpp - Polynomial weighted fitting plugin for KST.
                             -------------------
    begin                : Jun 6, 2004
    copyright            : (C) 2004 by The University of British Columbia
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "../linear_weighted.h"

double calculate_matrix_entry( double dX, int iPos ) {
  double dY;

  dY = pow( dX, (double)iPos );

  return dY;
}

extern "C" int parameterName(int iIndex, char** pName);
extern "C" int kstfit_polynomial_weighted(
  const double *const inArrays[], 
  const int inArrayLens[],
  const double inScalars[],
  double *outArrays[], int outArrayLens[],
  double outScalars[]);

int kstfit_polynomial_weighted(
  const double *const inArrays[], 
  const int inArrayLens[],
	const double inScalars[],
	double *outArrays[], int outArrayLens[],
	double outScalars[])
{
  int iRetVal = -1;
  int iNumParams;

  iNumParams = 1 + (int)floor( inScalars[0] );
  if( iNumParams > 0 ) {
    iRetVal = kstfit_linear_weighted( inArrays, inArrayLens, 
                                        outArrays, outArrayLens, 
                                        outScalars, iNumParams );
  }

  return iRetVal;
}

int parameterName(int iIndex, char** pName) 
{
  char name[20];

  sprintf( name, "x^%d", iIndex );
  *pName = strdup( name );

  return 1;
}
