/***************************************************************************
                          settings.cpp  -  description                              
                             -------------------                                         
    begin                : Sat May 20 2000                                           
    copyright            : (C) 2000 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "settings.h"
#include <pwd.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string>
#include <errno.h>
#include <stdio.h>
#include "kmysqladmin/helpers/helpers.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include <qfont.h>
#include <qcolor.h>
#include <kglobal.h>
#include <kconfig.h>

#define _GLOBAL_SECTION "GLOBALS"
#define _USER "last_user"
#define _HOST "last_host"
#define _PORT "last_port"
#define _PASS "last_password"

#define _FONT_SECTION "displayfonts"
#define _FIX_FONT "fixed_font"
#define _NPROP_FONT "non_prop_font"

#define _THREAD_POLLTIME "thread_polltime"
#define _STATUS_POLLTIME "status_polltime"

#define _SCRIPTEDITOR_SECTION "script_editor"
#define _SCRIPTRES_FORMATTED "script_result_formatted"
#define _SCRIPT_HIGHLIGHTED "script_syntax_highlight"

CSettings GlobalSettings;

using namespace std;

void CSettings::set_fixed_font(const QFont&fnt)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    k->writeEntry(_FIX_FONT,fnt);
    make_f_font_signal();
}

QFont CSettings::get_fixed_font()
{
    QFont fnt("fixed");
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    return k->readFontEntry(_FIX_FONT,&fnt);
}

void CSettings::set_nprop_font(const QFont&fnt)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    k->writeEntry(_NPROP_FONT,fnt);
    make_np_font_signal();
}

QFont CSettings::get_nonprop_font()
{
    QFont fnt("Sans");
    KConfig * k = KGlobal::config();
    k->setGroup(_FONT_SECTION);
    return k->readFontEntry(_NPROP_FONT,&fnt);
}

bool CSettings::init_files()
{
    uid_t user_id;
    struct passwd*zgr;
    std::string init_file;
    int ret;
    FILE*init_f;

    user_id = geteuid();
    zgr = getpwuid(user_id);
    init_file = zgr->pw_dir;
    init_file+="/.kmysqladmin";
    int mode = 127;

    ret = mkdir(init_file.c_str(),S_IRUSR|S_IWUSR|S_IXUSR );
    if (ret == -1) {
        if (errno == EEXIST) {
            ret = 0;
        } else {
            perror("Error creating DIR");
        }
    }

    if (ret == -1) {
        return false;
    }
    ret = chmod(init_file.c_str(),S_IRUSR|S_IWUSR|S_IXUSR);
    std::string settings_file = init_file;

    init_file+="/last_session";
    settings_file+="/Settings";

    mode = umask(mode);
    
    init_f = fopen(init_file.c_str(),"a+");

    if (!init_f) 
        perror("Error open file");
    else
        fclose(init_f);
    
    init_f = fopen(settings_file.c_str(),"a+");
    if (!init_f) 
        perror("Error open settings file");
    else
        fclose(init_f);

    umask(mode);

    chmod(init_file.c_str(),S_IRUSR|S_IWUSR);

    LastInit.FileName(init_file);
    LastInit.Path() = "GLOBALS";

    return true;
}

CSettings::CSettings()
{
    init_files();
}

CSettings::~CSettings()
{
}

void CSettings::SaveLastLogin(const std::string user,const std::string host,
                   const std::string port,const std::string pass)
{
    LastInit.SetValue(_USER,user);
    LastInit.SetValue(_HOST,host);
    LastInit.SetValue(_PORT,port);
    LastInit.SetValue(_PASS,pass);
}

bool CSettings::RetrieveLastLogin(std::string&user,std::string&host,
                                  std::string&port,std::string&pass)
{
    std::string def = "";
    user = LastInit.ReadValue(_USER,def);
    host = LastInit.ReadValue(_HOST,def);
    port = LastInit.ReadValue(_PORT,def);
    pass = LastInit.ReadValue(_PASS,def);
    return true;
}

void CSettings::ThreadPolltime(int aTimeout)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_THREAD_POLLTIME,aTimeout);
    make_thread_signal(aTimeout);
}

int CSettings::ThreadPolltime()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readNumEntry(_THREAD_POLLTIME,60);
}

void CSettings::StatusPolltime(int aTimeout)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    k->writeEntry(_STATUS_POLLTIME,aTimeout);
    make_status_signal(aTimeout);
}

int CSettings::StatusPolltime()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_GLOBAL_SECTION);
    return k->readNumEntry(_STATUS_POLLTIME,60);
}

bool CSettings::ScriptOutputAsRich()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry(_SCRIPTRES_FORMATTED,false);
}

void CSettings::ScriptOutputAsRich(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry(_SCRIPTRES_FORMATTED,how);
}

bool CSettings::SyntaxHighlight()const
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry(_SCRIPT_HIGHLIGHTED,true);
}

void CSettings::SyntaxHighlight(bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry(_SCRIPT_HIGHLIGHTED,how);
}

QColor CSettings::getScriptColor(const std::string&which,const QColor&aDefaultColor)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readColorEntry((which+"_color").c_str(),&aDefaultColor);
}

void CSettings::setScriptColor(const std::string&which,const QColor&aColor)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);    
    k->writeEntry((which+"_color").c_str(),aColor);
}

bool CSettings::getScriptbold(const std::string&which,bool def)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry((which+"_bold").c_str(),def);
}

void CSettings::setScriptbold(const std::string&which,bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry((which+"_bold").c_str(),how);
}

bool CSettings::getScriptit(const std::string&which,bool def)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    return k->readBoolEntry((which+"_italic").c_str(),def);
}

void CSettings::setScriptit(const std::string&which,bool how)
{
    KConfig * k = KGlobal::config();
    k->setGroup(_SCRIPTEDITOR_SECTION);
    k->writeEntry((which+"_italic").c_str(),how);
}
