// -*- Mode: C++; -*-
#ifndef e_pattern_included
#define e_pattern_included

#include "PatternPair.h"
#include "kmysqladmin/helpers/stringlist.h"

class e_patternpair:virtual public CPatternPair
{

protected:
    stringIlist enums;
    bool m_Set;
    void init(){enums.resize(0);m_Set = false;}

public:
    e_patternpair(const char*Entry,const char*Pattern,const char*op="LIKE",bool no_escape=false):CPatternPair(Entry,Pattern,op,no_escape){init();}
    e_patternpair(const std::string&Entry,const std::string&Pattern,const std::string&op="LIKE",bool no_escape=false):CPatternPair(Entry,Pattern,op,no_escape){init();}
    e_patternpair():CPatternPair(){init();}
    e_patternpair(const CPatternPair&old):CPatternPair(old){init();}
    e_patternpair(const e_patternpair&old):CPatternPair(){copy_old(old);enums=old.enums;m_Set=old.m_Set;}

    e_patternpair&operator=(const e_patternpair&old){copy_old(old);enums=old.enums;m_Set=old.m_Set;return *this;} 
    e_patternpair&operator=(const CPatternPair&old){copy_old(old);init();return *this;}

    void set_enumlist(const stringIlist& n_enums){enums = n_enums;}
    void set_is_set(const bool isSet){m_Set = isSet;}
    const bool get_is_set()const{return m_Set;}
    const stringIlist&enum_list()const{return enums;}

    const int operator<(const e_patternpair&old)const;
    const int operator==(const e_patternpair&old)const;
};

inline const int e_patternpair::operator <(const e_patternpair&old)const
{
    return pattern<old.pattern;
}

inline const int e_patternpair::operator==(const e_patternpair&old)const
{
    return pattern==old.pattern;
}


typedef std::vector<e_patternpair> e_PatternList;

//class e_PatternList:virtual public PatternList{};

typedef e_PatternList::iterator e_PatternIterator;
typedef e_PatternList::const_iterator Ce_PatternIterator;

#endif
