// -*- C++ -*-
/*****************************************************************************
 * KWATCH --- KDE Log File Viewer
 *
 * $Id: kwatchconf.cpp,v 1.5 2001/09/12 15:56:51 mj Exp $
 *
 * Configuration parameters of the application
 *
 *****************************************************************************
 * Copyright (C) 2000
 *  _____ _____
 * |     |___  |   Martin Junius             Internet:  mailto:mj@m-j-s.net
 * | | | |   | |   Radiumstr. 18                        http://www.m-j-s.net/
 * |_|_|_|@home|   D-51069 Koeln, Germany
 *
 * Based on kwatch 0.3, with the following copyright notice:
 *
 * Kwatch is Copyright (C) 1997,1998 Ralph C. Weichert and can be
 * distributed freely under the terms of the GNU General Public License
 * (see file COPYING)
 *****************************************************************************
 * This file is part of KWATCH.
 *
 * KWATCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * KWATCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with KWATCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "kwatchconf.h"


//DEBUG
#include <stdio.h>



void kwatchConf::save(KConfig *config)
{
//    fprintf(stderr, "kwatchConf::save()\n");

    config->setGroup  ("Conf");
    config->writeEntry("Geometry"  , geometry);
    config->writeEntry("LogFiles"  , logfiles, ':');
    config->writeEntry("Font"      , font);
    config->writeEntry("Foreground", fg);
    config->writeEntry("Background", bg);
    config->writeEntry("LogDir"    , logdir);
    config->writeEntry("MaxLines"  , maxlines);
    config->writeEntry("BufSize"   , bufsize);
    config->writeEntry("ShowMenu"  , showmenu);
    config->writeEntry("EnableCall", enableCall);
    config->writeEntry("EnableLog" , enableLog);
    config->writeEntry("SoundCall" , soundCall);
    config->writeEntry("SoundLog"  , soundLog);
    config->sync();
}



void kwatchConf::read(KConfig *config)
{
    QRect  def_geometry = DEFAULT_GEOMETRY;
    QFont  def_font     = DEFAULT_FONT;
    QColor def_fg       = DEFAULT_FG;
    QColor def_bg       = DEFAULT_BG;
    
//    fprintf(stderr, "kwatchConf::read()\n");

    config->setGroup("Conf");
    geometry   = config->readRectEntry ("Geometry"  , &def_geometry);
    logfiles   = config->readListEntry ("LogFiles"  , ':');
    font       = config->readFontEntry ("Font"      , &def_font);
    fg         = config->readColorEntry("Foreground", &def_fg);
    bg         = config->readColorEntry("Background", &def_bg);
    logdir     = config->readPathEntry ("LogDir"    , DEFAULT_LOGDIR);
    maxlines   = config->readNumEntry  ("MaxLines"  , DEFAULT_MAXLINES);
    bufsize    = config->readNumEntry  ("BufSize"   , DEFAULT_BUFSIZE);
    showmenu   = config->readBoolEntry ("ShowMenu"  , DEFAULT_SHOWMENU);
    enableCall = config->readBoolEntry ("EnableCall", DEFAULT_ENABLECALL);
    soundCall  = config->readPathEntry ("SoundCall");
    enableLog  = config->readBoolEntry ("EnableLog" ,DEFAULT_ENABLELOG);
    soundLog   = config->readPathEntry ("SoundLog");
    
}
