/*
     File: khronopanel.h
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KHRONO_PANEL_H
#define KHRONO_PANEL_H

#include <qpushbutton.h>
#include <qlayout.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlcdnumber.h>
#include <qspinbox.h>
#include <kconfig.h>
#include <qpopupmenu.h>
#include "khronotimer.h"

class KhronoDisplay;
class KhronoTimeDisplay;

class KhronoPanel : public QWidget
{
  Q_OBJECT
public:
  KhronoPanel( QWidget *parent=0, const char *name=0 );
  KhronoDisplay* getDisplay();
  void setConfig(KConfig*);
  
signals:
  void themeChanged(QColorGroup*);

protected slots:
  void setMode(int);
  void setStart(bool);
  void setPause(bool);
  void lap();
  void setCountdown();
  void about();
  void help();
  void helpPopup();
  void setTheme();
  virtual void resizeEvent(QResizeEvent*);
  virtual void closeEvent(QCloseEvent*);
  void alarm();
  
private:
  void saveTheme(QString *);
  void saveAlarm(QString *, int);
  void saveSize(const QSize&);
  void saveMode(int);
  void saveCountdown(int, int, int, int);
  QPushButton *modeButton, *startStopButton, *setButton, *lapButton,
              *resetButton, *pauseButton, *aboutButton, *themeButton;
  QPixmap *pxPlay, *pxStop, *pxPause, *pxSet, *pxReset, *pxLap,
          *pxMode, *pxAbout, *pxTheme;
  KhronoDisplay *display;
  QVBoxLayout *mainLayout;
  QWidget *buttonPanel;
  QHBoxLayout *buttonLayout;
  //char** modeStr;
  KConfig *config_;
  QPopupMenu *helpMenu;
  QString *alarmFile;
  int alarmRepeat;
  QString *colors;
};

class SetDialog : public QDialog
{
  Q_OBJECT
public:
  SetDialog( QWidget * parent=0, const char * name=0 );
  static const int OK=1;
  static const int CANCEL=0;
  int getDays();
  int getHours();
  int getMins();
  int getSecs();
  
private slots:
  void okClicked();
  void cancelClicked();

private:
  QLineEdit *btDays, *btHours, *btMins, *btSecs;
  QLabel *lbDays, *lbHours, *lbMins, *lbSecs;
  QWidget *pnTf, *pnLb;
  //QVBoxLayout *loTf, *loLb;
  //QHBoxLayout *loMain;
  QGridLayout *lo;
  QHBoxLayout *loOk;
  QPushButton *btOk, *btCancel;
  QWidget *pnOk;
};

class AlarmLineEdit;

class ThemeDialog : public QDialog
{
  Q_OBJECT
public:
  ThemeDialog( QString* _theme, QString* _alarmFile, int _repeat, QWidget * parent=0, const char * name=0 );
  static const int OK=1;
  static const int CANCEL=0;
  static const QString& GREEN;
  static const QString& ORANGE;
  static const QString& CLASSIC;
  static const QString& RETRO_ORANGE;
  static const QString& RETRO_GREEN;
  static const QString& DEFAULT;
  static QColorGroup* getThemeValue(QString*);
  const QString& getChosenTheme();
  const char* getChosenAlarm();
  int getChosenRepeat();

private slots:
  void okClicked();
  void cancelClicked();
  void alarmClicked();
  void themeChanged(int);

private:
  static QColorGroup** themes;
  static void initThemes();
  static const QString& getThemeName(int);
  QLCDNumber *testLCD;
  QString* colors;
  QButtonGroup *bg;
  QGroupBox *gbAlarm;
  QLabel *lbAlarm;
  QRadioButton *bt1, *bt2, *bt3, *bt4, *bt5;
  QHBoxLayout *loOk, *loTheme, *loAlarm;
  QVBoxLayout *lo;
  QPushButton *btOk, *btCancel, *btAlarm;
  QSpinBox *sbAlarm;
  AlarmLineEdit *tfAlarm;
};

class AlarmLineEdit : public QLineEdit
{
public:
  AlarmLineEdit( QWidget * parent=0, const char * name=0 )
   : QLineEdit( parent, name ) {}
protected:
  virtual void keyPressEvent ( QKeyEvent * ) {}
};

#endif /* KHRONO_PANEL_H */
