/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _SETTINGSDLG_H_
#define _SETTINGSDLG_H_

#include <qdialog.h>

class QLineEdit;
class QCheckBox;
class KIntegerLine;
class KIntNumInput;


class FontButton : public QPushButton
{
    Q_OBJECT
public:
    FontButton( const QString &text, QWidget *parent=0, const char *name=0 );

private slots:
    void chooseFont();
};


class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    SettingsDialog( QWidget *parent=0, const char *name=0 );

protected slots:
     virtual void done(int res);

private:
    void readSettings();
    void writeSettings();

    KIntNumInput *timeoutedit;
    KIntNumInput *contextedit;
    QLineEdit *cvspathedit;
    QLineEdit *usernameedit;
    QLineEdit *editoredit;
    QLineEdit *diffoptedit;
    QCheckBox *remotestatusbox;
    QCheckBox *localstatusbox;
#if 0
    QCheckBox *usedcopbox;
    QLineEdit *clientedit;
    QLineEdit *objectedit;
#endif
    FontButton *protocolfontbox;
    FontButton *annotatefontbox;
    FontButton *difffontbox;
    QCheckBox *splitterbox;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
