/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _DIFFDLG_H_
#define _DIFFDLG_H_

#include <qdialog.h>
#include <qlabel.h>
#include <qmultilinedit.h>
#include <qcheckbox.h>
#include "diffview.h"


class DiffDialog : public QDialog
{
    Q_OBJECT

public:
    DiffDialog( QWidget *parent=0, const char *name=0, bool modal=false );

    bool parseCvsDiff(QString sandbox, QString repository,
                      QString filename, QString revA, QString revB);
    void updateViews();

    static void loadOptions(KConfig *config);
    static void saveOptions(KConfig *config);

protected slots:
    virtual void done(int r);

protected:
    virtual void keyPressEvent(QKeyEvent *e);

private slots:
    void toggleSynchronize(bool b);
    
private:
    struct Options {
        QSize size;
        bool sync;
    };
    static Options *options;

    QLabel *revlabel1, *revlabel2;
    DiffView *diff1, *diff2;
    QCheckBox *syncbox;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
