/***************************************************************************
                          rectdlg.cpp  -  description
                             -------------------
    begin                : Sat Apr 28 2001
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <klocale.h>
#include <kapp.h>
#include "kpldoubleedit.h"
#include "rectitem.h"
#include "rectdlg.h"

RectDlg::RectDlg(QWidget* parent, KplDoc* model, RectItem* rd0) :
 DecoDlg(parent, model, rd0, 4), rd(rd0)
{
  resize(400, 170);
  grid->addWidget(new QLabel(i18n("Width"), this), 0, 0);
  grid->addWidget(eWidth = new KplDoubleEdit(rd->width, 0.1, 200.0, this),
                  0, 1);
  grid->addWidget(new QLabel("cm", this), 0, 2);
  grid->addWidget(new QLabel(i18n("Height"), this), 0, 4);
  grid->addWidget(eHeight = new KplDoubleEdit(rd->height, 0.1, 200.0, this),
                  0, 5);
  grid->addWidget(new QLabel("cm", this), 0, 6);
  initEntries(1);
  lSize->setText(i18n("Line width"));
  grid->addWidget(fill = new QCheckBox(i18n("Filled"), this), 3, 5);
  fill->setChecked(rd->filled);
  initButtons();
  connect(bHelp, SIGNAL(clicked()), SLOT(slotHelp()));
  connect(bOK, SIGNAL(clicked()), SLOT(slotOK()));
  connect(bApply, SIGNAL(clicked()), SLOT(slotApply()));
}

RectDlg::~RectDlg()
{
}

void RectDlg::getValues(bool ok)
{
  rd->width = eWidth->value();
  rd->height = eHeight->value();
  rd->filled = fill->isChecked();
  DecoDlg::getValues(ok);
}

void RectDlg::slotOK()
{
  getValues(true);
}

void RectDlg::slotApply()
{
  getValues(false);
}

void RectDlg::slotHelp()
{
  kapp->invokeHelp((rd->iType() == KplItem::Rectangle) ?
                   "SEC-RECT" : "SEC-ELLIPSE");
}
