/***************************************************************************
                          edittextdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITTEXTDLG_H
#define EDITTEXTDLG_H

#include <qdialog.h>
#include "kgraph.h"

class QLineEdit;
class QRadioButton;
class QButtonGroup;

/**
  * Text preview widget class. Provides a widget for the
  * previewing of text containing subscripts, superscripts, and several fonts.
  * @author Werner Stille
  */
class Preview : public QWidget, public KGraph {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   */
  Preview(QWidget* parent);
  /** Destructor. */
  ~Preview();

public slots:
  /**
   * Updates the text display.
   * @param s text.
   */
  void setText(const QString& s);

protected:
  /**
   * Reimplemented for painting the text preview widget.
   */
  virtual void paintEvent(QPaintEvent*);
  QString str;
};

/**
  * Text editing dialog class. Provides a dialog to edit
  * text containing subscripts, superscripts, and several fonts.
  * @author Werner Stille
  */
class EditTextDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param ed pointer to QLineEdit widget containing the text.
   */
  EditTextDlg(QWidget* parent, QLineEdit* ed);
  /** Destructor. */
  ~EditTextDlg();

protected:
  QString sfont;
  Preview* editPreview;
  QLineEdit *font, *ed, *text;
  QButtonGroup *bg1, *bg2;

protected slots:
  /** Concatenates current text and control sequence. */
  void slotCat();
  /** Builds control sequence with selected font. */
  void slotFont();
  /** Builds control sequence with selected vertical position. */
  void slotPos();
  /** Applies changes and leaves the dialog. */
  void slotOK();
};

#endif
