/***************************************************************************
                          kplview.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sat Apr 24 15:14:00 MEST 1999

    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLVIEW_H
#define KPLVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <qwidget.h>
#include "kgraph.h"

class QScrollBar;
class KplApp;
class KplWidget;
class KplDoc;

/**
  * Kpl main view class.
  * Provides methods for painting and erasing the page widget and generating PostScript files.
  * @author Werner Stille
  */
class KplView : public QWidget, public KGraph
{
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param f zoom factor.
   */
  KplView(KplApp* parent, double f);
  /** Destructor. */
  ~KplView();
  /**
   * Contains the implementation for printing functionality.
   * @param printer printer device.
   */
	void print(QPaintDevice* printer) const;
  /** Adjusts scrollbars and page widget size. */
  void layout();
  /** Plots frame, grid, labels, data arrays, ordinary and parametric functions. */
  void doDraw();
  /** Erases page widget. */
  void eraseWidget();
  /**
   * Paints or erases page widget.
   * @param paint true for painting.
   */
  void doPaint(bool paint);

public slots:
  /** Scrolls left. */
  void slotScrollLeft();
  /** Scrolls right. */
  void slotScrollRight();
  /** Scrolls up. */
  void slotScrollUp();
  /** Scrolls down. */
  void slotScrollDown();
  /** Scrolls page up. */
  void slotScrollPageUp();
  /** Scrolls page down. */
  void slotScrollPageDown();
  /** Scrolls page left. */
  void slotScrollPageLeft();
  /** Scrolls page right. */
  void slotScrollPageRight();
  /** Scrolls to left margin. */
  void slotScrollHomeLeft();
  /** Scrolls to bottom margin. */
  void slotScrollHomeDown();
  /** Scrolls to right margin. */
  void slotScrollEndRight();
  /** Scrolls to top margin. */
  void slotScrollEndUp();
  /** Paints the page widget. */
  void paintWidget();

protected:
  /**
   * Reimplemented for adjusting of scrollbars and page widget and
   * repainting of page widget.
   */
  virtual void resizeEvent(QResizeEvent*);
  KplDoc* doc;
  KplWidget* page;
  QScrollBar *horScrollBar, *vertScrollBar;
  int sHScrollPos, sVScrollPos, xPict, yPict, scrx, scry;
  double fZoom;
  static const int scrollBarSize;

  friend KplApp;

protected slots:
  /**
   * Updates page widget according to horizontal scrolling.
   * @param pos new horizontal scrollbar position.
   */
  void slotHorScroll(int pos);
  /**
   * Updates page widget according to vertical scrolling.
   * @param pos new vertical scrollbar position.
   */
  void slotVertScroll(int pos);
};

#endif // KPLVIEW_H
