/***************************************************************************
                          kplitem.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Wed Aug 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <ksimpleconfig.h>
#include "kplitem.h"
#include "kplgraph.h"
#include "utils.h"

KplItem::KplItem() : active(true)
{
}

KplItem::KplItem(KSimpleConfig* plo)
{
  active = plo->readBoolEntry("active", true);
}

KplItem::~KplItem()
{
}

void KplItem::writePlo(FILE* f, const KURL&, bool) const
{
  if (!active)
    fprintf(f, "active=false\n");
}

void KplItem::normalize(double, double)
{
}

void KplItem::expoItem(int*, int*, double*, double*) const
{
}

void KplItem::minMax(double*, double*, double*, double*) const
{
}

void KplItem::setPar(int, double, bool)
{
}

void KplItem::exportTable(FILE*, KplDoc*) const
{
}

ScaledItem::ScaledItem() : symb(0), color(0), fx(1.0), fy(1.0)
{
}

ScaledItem::ScaledItem(Kpl::AutoStruct* aut) :
 symb(aut->autoSymb), color(aut->colData), fx(1.0), fy(1.0)
{
}

ScaledItem::ScaledItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) : KplItem(plo)
{
  readPlo(plo, aut);
}

ScaledItem::ScaledItem(bool act, int sym, const QString& col,
                       double fxa, double fya) :
 symb(sym), fx(fxa), fy(fya)
{
  active = act;
  unsigned u;
  sscanf(col.latin1(), "%x", &u);
  color = Utils::rgbQt(u);
}

ScaledItem::~ScaledItem()
{
}

void ScaledItem::readPlo(KSimpleConfig* plo, Kpl::AutoStruct* aut)
{
  symb = plo->readNumEntry("symb", aut->autoSymb);
  char s[256];
  strcpy(s, plo->readEntry("color", ""));
  if (strlen(s)) {
    unsigned u;
    sscanf(s, "%x", &u);
    color = Utils::rgbQt(u);
  } else
    color = aut->colData;
  fx = plo->readDoubleNumEntry("fx", 1.0);
  fy = plo->readDoubleNumEntry("fy", 1.0);
}

void ScaledItem::writePlo(FILE* f, const KURL& url, bool abs) const
{
  KplItem::writePlo(f, url, abs);
  fprintf(f, "symb=%i\ncolor=%x\nfx=%g\nfy=%g\n", symb, Utils::rgbQt1(color),
          fx, fy);
}

void ScaledItem::normalize(double fx0, double fy0)
{
  fx = fx0;
  fy = fy0;
}

void ScaledItem::setProperties(KplGraph* g) const
{
  g->setColData(color);
  g->setSymbol(symb);
  g->fxn = fx;
  g->fyn = fy;
}
